/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.i18n.Bundle;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.ui.table.ElxTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class EditableTable
extends JPanel
implements ListSelectionListener,
ActionListener {
    public static final String PLUS = "plus";
    public static final String EDIT = "edit";
    public static final String MINUS = "minus";
    public static final String COPY = "copy";
    public static final String PASTE = "paste";
    protected boolean m_ShowAddDelete;
    protected boolean m_ShowEdit;
    protected boolean m_ShowCopyPaste;
    protected JTableEx m_Table;
    protected Box m_Items;
    protected List<ActionListener> m_Listeners = new ArrayList<ActionListener>();
    protected JButton m_Plus;
    protected JButton m_Edit;
    protected JButton m_Minus;
    protected JButton m_Copy;
    protected JButton m_Paste;
    protected int m_MinRows;

    public EditableTable(TableModel tableModel) {
        this(tableModel, true, true);
    }

    public EditableTable(TableModel tableModel, boolean bl) {
        this(tableModel, bl, true);
    }

    public EditableTable(TableModel tableModel, boolean bl, boolean bl2) {
        this(tableModel, bl, bl2, true);
    }

    public EditableTable(TableModel tableModel, boolean bl, boolean bl2, boolean bl3) {
        this.m_ShowAddDelete = bl3;
        this.m_ShowEdit = bl;
        this.m_ShowCopyPaste = bl2;
        this.setLayout(new BorderLayout());
        this.initButtons();
        this.initTable(tableModel);
        this.m_Plus.setMnemonic('N');
        this.m_Minus.setMnemonic('D');
        this.m_Edit.setMnemonic('E');
        this.m_Copy.setMnemonic('C');
        this.m_Paste.setMnemonic('V');
        KeyStroke keyStroke = KeyStroke.getKeyStroke(127, 0);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(67, 2);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(86, 2);
        NamedAction namedAction = new NamedAction(MINUS);
        if (bl3) {
            this.m_Table.getActionMap().put(namedAction, namedAction);
            this.m_Table.getInputMap(0).put(keyStroke, namedAction);
        }
        if (this.m_ShowCopyPaste) {
            NamedAction namedAction2 = new NamedAction(COPY);
            NamedAction namedAction3 = new NamedAction(PASTE);
            this.m_Table.getActionMap().put(namedAction2, namedAction2);
            this.m_Table.getActionMap().put(namedAction3, namedAction3);
            this.m_Table.getInputMap(0).put(keyStroke2, namedAction2);
            this.m_Table.getInputMap(0).put(keyStroke3, namedAction3);
        }
        this.checkEnabled();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_Table.setEnabled(bl);
        this.checkEnabled();
    }

    public void setModel(TableModel tableModel) {
        this.m_Table.setModel(tableModel);
    }

    public void setAutoCreateColumns(boolean bl) {
        this.m_Table.setAutoCreateColumns(bl);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        ListSelectionModel listSelectionModel = this.m_Table.getSelectionModel();
        listSelectionModel.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        ListSelectionModel listSelectionModel = this.m_Table.getSelectionModel();
        listSelectionModel.removeListSelectionListener(listSelectionListener);
    }

    public JTable getTable() {
        return this.m_Table;
    }

    public void setColumnWidth(int n, int n2) {
        this.m_Table.getColumnModel().getColumn(n).setMaxWidth(n2);
    }

    public void setSingleSelectionMode() {
        ListSelectionModel listSelectionModel = this.m_Table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
    }

    public void setAutoResizeMode(int n) {
        this.m_Table.setAutoResizeMode(n);
    }

    public void setMinRows(int n) {
        this.m_MinRows = n;
    }

    public int getRowCount() {
        return this.m_Table.getRowCount();
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_Listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_Listeners.remove(actionListener);
    }

    public void editCell(int n, int n2) {
        this.select(n);
        this.m_Table.requestFocusInWindow();
        this.m_Table.editCellAt(n, n2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditableTable.this.m_Table.getEditorComponent().requestFocusInWindow();
            }
        });
    }

    public void setColumnEditors(int[] nArray, DefaultCellEditor[] defaultCellEditorArray) {
        TableColumnModel tableColumnModel = this.m_Table.getColumnModel();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(nArray[i]);
            tableColumn.setCellEditor(defaultCellEditorArray[i]);
        }
    }

    protected JButton button(String string, String string2, Icon icon) {
        JButton jButton = new JButton(null, icon);
        jButton.setActionCommand(string);
        jButton.setToolTipText(string2);
        jButton.addActionListener(this);
        return jButton;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = this.m_Items.getPreferredSize().height;
        Border border = this.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(this);
            dimension.height += insets.top + insets.bottom;
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getSelectedRow() {
        return this.m_Table.getSelectedRow();
    }

    public int[] getSelectedRows() {
        return this.m_Table.getSelectedRows();
    }

    public void select(int n) {
        this.m_Table.getSelectionModel().setSelectionInterval(n, n);
    }

    public void select(int n, int n2) {
        ListSelectionModel listSelectionModel = this.m_Table.getSelectionModel();
        if (listSelectionModel.getSelectionMode() == 0) {
            this.select(n);
        } else {
            this.m_Table.getSelectionModel().setSelectionInterval(n, n2);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.checkEnabled();
        }
    }

    public void disposeEditor() {
        TableCellEditor tableCellEditor = this.m_Table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
            this.m_Table.removeEditor();
        }
    }

    public void setDefaultRenderer(Class<?> clazz, TableCellRenderer tableCellRenderer) {
        this.m_Table.setDefaultRenderer(clazz, tableCellRenderer);
    }

    public void setDefaultEditor(Class<?> clazz, TableCellEditor tableCellEditor) {
        this.m_Table.setDefaultEditor(clazz, tableCellEditor);
    }

    public void setColumnRenderer(int n, TableCellRenderer tableCellRenderer) {
        this.m_Table.setColumnRenderer(n, tableCellRenderer);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.disposeEditor();
        Iterator<ActionListener> iterator = this.m_Listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().actionPerformed(actionEvent);
        }
        this.checkEnabled();
    }

    public void checkEnabled() {
        if (this.m_Table.isEnabled()) {
            int[] nArray = this.m_Table.getSelectedRows();
            this.m_Plus.setEnabled(true);
            if (this.m_ShowEdit) {
                this.m_Edit.setEnabled(nArray.length == 1);
            }
            this.m_Minus.setEnabled(nArray.length > 0 && this.m_Table.getRowCount() > this.m_MinRows);
            this.m_Copy.setEnabled(nArray.length > 0);
            this.m_Paste.setEnabled(true);
        } else {
            this.m_Plus.setEnabled(false);
            if (this.m_ShowEdit) {
                this.m_Edit.setEnabled(false);
            }
            this.m_Minus.setEnabled(false);
            this.m_Copy.setEnabled(false);
            this.m_Paste.setEnabled(false);
        }
    }

    protected void initButtons() {
        this.m_Items = new Box(1);
        this.m_Plus = this.button(PLUS, Bundle.ARCH.getString("Add"), StandardIcons.NEW);
        this.m_Edit = this.button(EDIT, Bundle.ARCH.getString("Edit"), StandardIcons.PROPERTIES);
        this.m_Minus = this.button(MINUS, Bundle.ARCH.getString("Delete"), StandardIcons.DELETE);
        this.m_Copy = this.button(COPY, Bundle.ARCH.getString("Copy"), StandardIcons.COPY);
        this.m_Paste = this.button(PASTE, Bundle.ARCH.getString("Paste"), StandardIcons.PASTE);
        if (this.m_ShowAddDelete) {
            this.m_Items.add(this.m_Plus);
        }
        if (this.m_ShowEdit) {
            this.m_Items.add(this.m_Edit);
        }
        if (this.m_ShowAddDelete) {
            this.m_Items.add(this.m_Minus);
        }
        if (this.m_ShowCopyPaste) {
            this.m_Items.add(this.m_Copy);
            this.m_Items.add(this.m_Paste);
        }
        this.add((Component)this.m_Items, "West");
    }

    protected void initTable(TableModel tableModel) {
        this.m_Table = this.newTable(tableModel);
        this.m_Table.addMouseListener(new ML());
        this.m_Table.setAutoResizeMode(0);
        ListSelectionModel listSelectionModel = this.m_Table.getSelectionModel();
        listSelectionModel.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.m_Table);
        this.add((Component)jScrollPane, "Center");
    }

    protected JTableEx newTable(TableModel tableModel) {
        return new JTableEx(tableModel);
    }

    protected void edit() {
        if (this.m_ShowEdit) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, EDIT);
            this.actionPerformed(actionEvent);
        }
    }

    protected void doPopup(MouseEvent mouseEvent) {
    }

    private class NamedAction
    extends AbstractAction {
        private String m_Name;

        public NamedAction(String string) {
            this.m_Name = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EditableTable.this.m_Table.getSelectedRowCount() > 0) {
                ActionEvent actionEvent2 = new ActionEvent(this, 1001, this.m_Name);
                EditableTable.this.actionPerformed(actionEvent2);
            }
        }
    }

    public static class JTableEx
    extends ElxTable {
        private TableCellRenderer[] m_ColumnRenderers;

        public JTableEx(TableModel tableModel) {
            this.setModel(tableModel);
        }

        public void setAutoCreateColumns(boolean bl) {
            this.autoCreateColumnsFromModel = bl;
        }

        public void setColumnRenderer(int n, TableCellRenderer tableCellRenderer) {
            if (this.m_ColumnRenderers == null) {
                this.m_ColumnRenderers = new TableCellRenderer[this.getModel().getColumnCount()];
            }
            this.m_ColumnRenderers[n] = tableCellRenderer;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            TableCellRenderer tableCellRenderer = null;
            if (this.m_ColumnRenderers != null) {
                tableCellRenderer = this.m_ColumnRenderers[n2];
            }
            if (tableCellRenderer == null) {
                tableCellRenderer = super.getCellRenderer(n, n2);
            }
            return tableCellRenderer;
        }
    }

    private class ML
    extends MouseAdapter {
        private ML() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                EditableTable.this.doPopup(mouseEvent);
            } else {
                super.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                EditableTable.this.doPopup(mouseEvent);
            } else {
                super.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Point point;
            int n;
            if (mouseEvent.getClickCount() == 2 && EditableTable.this.m_Table.isEnabled() && (n = EditableTable.this.m_Table.rowAtPoint(point = mouseEvent.getPoint())) >= 0) {
                EditableTable.this.edit();
            }
        }
    }
}

