/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ElxComboBox
extends JComboBox<Object> {
    public ElxComboBox() {
        this.setRenderer(new CBR());
    }

    public ElxComboBox(ComboBoxModel comboBoxModel) {
        this();
        this.setModel(comboBoxModel);
    }

    public ElxComboBox(Object[] objectArray) {
        this();
        super.setModel(new ElxComboBoxModel(objectArray));
    }

    public ElxComboBox(Vector<?> vector) {
        this();
        Object[] objectArray = new Object[vector.size()];
        vector.toArray(objectArray);
        super.setModel(new ElxComboBoxModel(objectArray));
    }

    public void setModel(Object[] objectArray) {
        super.setModel(new ElxComboBoxModel(objectArray));
    }

    @Override
    public void setModel(ComboBoxModel comboBoxModel) {
        Object[] objectArray = new Object[comboBoxModel.getSize()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = comboBoxModel.getElementAt(i);
        }
        super.setModel(new ElxComboBoxModel(objectArray));
    }

    @Override
    public void setSelectedItem(Object object) {
        this.ensureExists(object);
        super.setSelectedItem(object);
        this.setForeground(this.isInvalid() ? Color.RED : this.getDefaultForeground());
    }

    protected Color getDefaultForeground() {
        if (this.isEnabled()) {
            return UIManager.getColor("ComboBox.foreground");
        }
        return UIManager.getColor("ComboBox.disabledForeground");
    }

    public boolean isInvalid() {
        ElxComboBoxModel elxComboBoxModel = (ElxComboBoxModel)this.getModel();
        return elxComboBoxModel.isInvalid();
    }

    private void ensureExists(Object object) {
        ElxComboBoxModel elxComboBoxModel = (ElxComboBoxModel)this.getModel();
        elxComboBoxModel.ensureExists(object);
    }

    private class CBR
    extends DefaultListCellRenderer {
        private int m_Height;

        public CBR() {
            this.setText("Test height so null entries aren't invisible");
            this.m_Height = super.getPreferredSize().height;
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            ElxComboBoxModel elxComboBoxModel = (ElxComboBoxModel)ElxComboBox.this.getModel();
            boolean bl3 = elxComboBoxModel.isInvalid() && n <= 0;
            super.setForeground(bl3 ? Color.RED : ElxComboBox.this.getDefaultForeground());
            return component;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.height = this.m_Height;
            return dimension;
        }

        @Override
        public void setForeground(Color color) {
        }
    }

    private class ElxComboBoxModel
    implements ComboBoxModel<Object> {
        private Object[] m_Elements;
        private Object m_Current;
        private boolean m_InvalidSelection;
        private List<ListDataListener> m_Listeners = new ArrayList<ListDataListener>();

        public ElxComboBoxModel(Object[] objectArray) {
            this.m_Elements = objectArray;
        }

        public void ensureExists(Object object) {
            if (!this.isValidElement(object)) {
                this.m_Current = object;
                this.m_InvalidSelection = true;
                this.fireChanged();
            }
        }

        @Override
        public void setSelectedItem(Object object) {
            Object object2 = this.m_Current;
            this.m_Current = object;
            if (this.isValidElement(object)) {
                this.m_InvalidSelection = false;
                this.fireChanged();
            }
            this.selectedItemChanged(object2, this.m_Current);
        }

        @Override
        public Object getSelectedItem() {
            return this.m_Current;
        }

        @Override
        public int getSize() {
            return this.m_Elements.length + (this.m_InvalidSelection ? 1 : 0);
        }

        @Override
        public Object getElementAt(int n) {
            if (this.m_InvalidSelection) {
                if (n == 0) {
                    return this.m_Current;
                }
                --n;
            }
            return this.m_Elements[n];
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
            this.m_Listeners.add(listDataListener);
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
            this.m_Listeners.remove(listDataListener);
        }

        public boolean isInvalid() {
            return this.m_InvalidSelection;
        }

        private boolean isValidElement(Object object) {
            for (Object object2 : this.m_Elements) {
                if (!this.isEqual(object2, object)) continue;
                return true;
            }
            return false;
        }

        private boolean isEqual(Object object, Object object2) {
            if (object == null || "" == object) {
                return object2 == null || "" == object2;
            }
            return object.equals(object2);
        }

        private void fireChanged() {
            int n = this.m_InvalidSelection ? 1 : 2;
            ListDataEvent listDataEvent = new ListDataEvent(this, n, 0, 0);
            for (ListDataListener listDataListener : this.m_Listeners) {
                listDataListener.contentsChanged(listDataEvent);
            }
        }

        private void selectedItemChanged(Object object, Object object2) {
            if (object != null) {
                ElxComboBox.this.fireItemStateChanged(new ItemEvent(ElxComboBox.this, 701, object, 2));
            }
            if (object2 != null) {
                ElxComboBox.this.fireItemStateChanged(new ItemEvent(ElxComboBox.this, 701, object2, 1));
            }
        }
    }
}

