/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.ui.ShadowBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class ElxSplitPane
extends JSplitPane {
    public ElxSplitPane() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public ElxSplitPane(int n) {
        this(n, false);
    }

    public ElxSplitPane(int n, boolean bl) {
        super(n, bl);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setDividerSize(4);
    }

    public ElxSplitPane(int n, Component component, Component component2) {
        this(n, false, component, component2);
    }

    public ElxSplitPane(int n, boolean bl, Component component, Component component2) {
        super(n, bl, component, component2);
        this.setUI(new ElxSplitPaneUI());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setDividerSize(4);
    }

    @Override
    public void setLeftComponent(Component component) {
        super.setLeftComponent(ElxSplitPane.firstWrapper(this.getOrientation(), component));
    }

    @Override
    public void setRightComponent(Component component) {
        super.setRightComponent(ElxSplitPane.firstWrapper(this.getOrientation(), component));
    }

    protected static Component firstWrapper(int n, Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof ElxSplitPane) {
            ((ElxSplitPane)component).firstOfSplit(n);
            return component;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        ShadowBorder shadowBorder = new ShadowBorder();
        if (n == 1) {
            shadowBorder.tightRight();
        } else {
            shadowBorder.tightBottom();
        }
        jPanel.setBorder(shadowBorder);
        jPanel.add(component);
        return jPanel;
    }

    protected static Component secondWrapper(int n, Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof ElxSplitPane) {
            ((ElxSplitPane)component).secondOfSplit(n);
            return component;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        ShadowBorder shadowBorder = new ShadowBorder();
        if (n == 1) {
            shadowBorder.tightLeft();
        } else {
            shadowBorder.tightTop();
        }
        jPanel.setBorder(shadowBorder);
        jPanel.add(component);
        return jPanel;
    }

    protected void firstOfSplit(int n) {
        if (n == 1) {
            this.tightRight();
        } else {
            this.tightBottom();
        }
    }

    protected void secondOfSplit(int n) {
        if (n == 1) {
            this.tightLeft();
        } else {
            this.tightTop();
        }
    }

    protected void tightLeft() {
        this.tightLeft(this.getComponent(0));
        this.tightLeft(this.getComponent(1));
    }

    protected void tightTop() {
        this.tightTop(this.getComponent(0));
        this.tightTop(this.getComponent(1));
    }

    protected void tightRight() {
        this.tightRight(this.getComponent(0));
        this.tightRight(this.getComponent(1));
    }

    protected void tightBottom() {
        this.tightBottom(this.getComponent(0));
        this.tightBottom(this.getComponent(1));
    }

    protected void tightLeft(Component component) {
        if (component instanceof ElxSplitPane) {
            ((ElxSplitPane)component).tightLeft();
        } else {
            ShadowBorder shadowBorder = (ShadowBorder)((JPanel)component).getBorder();
            shadowBorder.tightLeft();
        }
    }

    protected void tightTop(Component component) {
        if (component instanceof ElxSplitPane) {
            ((ElxSplitPane)component).tightTop();
        } else {
            ShadowBorder shadowBorder = (ShadowBorder)((JPanel)component).getBorder();
            shadowBorder.tightTop();
        }
    }

    protected void tightRight(Component component) {
        if (component instanceof ElxSplitPane) {
            ((ElxSplitPane)component).tightRight();
        } else {
            ShadowBorder shadowBorder = (ShadowBorder)((JPanel)component).getBorder();
            shadowBorder.tightRight();
        }
    }

    protected void tightBottom(Component component) {
        if (component instanceof ElxSplitPane) {
            ((ElxSplitPane)component).tightBottom();
        } else {
            ShadowBorder shadowBorder = (ShadowBorder)((JPanel)component).getBorder();
            shadowBorder.tightBottom();
        }
    }

    private static class ElxSplitPaneUI
    extends BasicSplitPaneUI {
        private ElxSplitPaneUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new ElxSplitPaneDivider(this);
        }
    }

    private static class ElxSplitPaneDivider
    extends BasicSplitPaneDivider {
        public ElxSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
            super(basicSplitPaneUI);
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.setColor(SystemColor.control);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
    }
}

