/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.arch.IUINavigator;
import com.elixirtech.arch.UINavigatorPath;
import com.elixirtech.ui.CurrentTab;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ElxTabbedPane
extends JTabbedPane
implements ChangeListener,
CurrentTab,
IUINavigator {
    protected CurrentTab m_CurrentTab;

    public ElxTabbedPane() {
        this.addChangeListener(this);
    }

    public ElxTabbedPane(int n) {
        super(n);
        this.addChangeListener(this);
    }

    public ElxTabbedPane(int n, int n2) {
        super(n, n2);
        this.addChangeListener(this);
    }

    @Override
    public void setCurrent(boolean bl) {
        if (this.m_CurrentTab != null) {
            this.m_CurrentTab.setCurrent(bl);
        }
    }

    public CurrentTab getCurrentTab() {
        return this.m_CurrentTab;
    }

    @Override
    public void addTab(String string, Component component) {
        boolean bl;
        Component component2 = string != null ? this.getTab(string) : null;
        boolean bl2 = bl = component2 == this.m_CurrentTab;
        if (component2 != null) {
            this.remove(component2);
        }
        if (bl || this.getTabCount() == 0) {
            this.m_CurrentTab = (CurrentTab)((Object)component);
            this.m_CurrentTab.setCurrent(true);
        }
        this.insertTab(string, null, component, null, this.getTabCount());
    }

    @Override
    public void addTab(String string, Icon icon, Component component, String string2) {
        boolean bl;
        Component component2 = string != null ? this.getTab(string) : null;
        boolean bl2 = bl = component2 == this.m_CurrentTab;
        if (component2 != null) {
            this.remove(component2);
        }
        if (bl || this.getTabCount() == 0) {
            this.m_CurrentTab = (CurrentTab)((Object)component);
        }
        this.insertTab(string, icon, component, string2, this.getTabCount());
    }

    @Override
    public void addTab(String string, Icon icon, Component component) {
        boolean bl;
        Component component2 = string != null ? this.getTab(string) : null;
        boolean bl2 = bl = component2 == this.m_CurrentTab;
        if (component2 != null) {
            this.remove(component2);
        }
        if (bl || this.getTabCount() == 0) {
            this.m_CurrentTab = (CurrentTab)((Object)component);
        }
        this.insertTab(string, icon, component, null, this.getTabCount());
    }

    @Override
    public void showUINavigator(UINavigatorPath uINavigatorPath) {
        String string;
        Component component;
        if (uINavigatorPath.hasNext() && (component = this.getTab(string = uINavigatorPath.next())) != null) {
            this.setSelectedComponent(component);
            if (component instanceof IUINavigator) {
                ((IUINavigator)((Object)component)).showUINavigator(uINavigatorPath);
            }
        }
    }

    @Override
    public void removeAll() {
        if (this.m_CurrentTab != null) {
            this.m_CurrentTab.setCurrent(false);
        }
        super.removeAll();
    }

    @Override
    public void setSelectedIndex(int n) {
        super.setSelectedIndex(n);
        this.stateChanged(null);
    }

    @Override
    public void setSelectedComponent(Component component) {
        super.setSelectedComponent(component);
        this.stateChanged(null);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        CurrentTab currentTab = (CurrentTab)((Object)this.getSelectedComponent());
        if (this.m_CurrentTab != currentTab) {
            if (this.m_CurrentTab != null) {
                this.m_CurrentTab.setCurrent(false);
            }
            this.m_CurrentTab = currentTab;
            if (this.m_CurrentTab != null) {
                this.m_CurrentTab.setCurrent(true);
            }
        }
    }

    private Component getTab(String string) {
        if (string == null) {
            return null;
        }
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.getTitleAt(i))) continue;
            return this.getComponentAt(i);
        }
        return null;
    }

    public static class TabLabel
    extends JLabel {
        public TabLabel(String string, Icon icon) {
            this.setText(string);
            this.setIcon(icon);
            this.setIconTextGap(5);
            this.setHorizontalTextPosition(4);
        }
    }
}

