/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.EscapableDialog;
import com.elixirtech.ui.FontChooserPanel;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.CodeBlock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class FontChooserDialog
extends EscapableDialog {
    private boolean m_IsOk;
    private FontChooserPanel m_FontPanel;

    public FontChooserDialog(Frame frame, Font font) {
        super(frame);
        this.setModal(true);
        Container container = this.getContentPane();
        container.add(this.createContent(font));
    }

    public boolean isOk() {
        return this.m_IsOk;
    }

    public Font getSelectedFont() {
        return this.m_FontPanel.getSelectedFont();
    }

    public void ok() {
        this.m_IsOk = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    private JPanel createContent(Font font) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        if (font == null) {
            font = new Font("Dialog", 10, 0);
        }
        this.m_FontPanel = new FontChooserPanel(font);
        jPanel.add(this.m_FontPanel);
        JPanel jPanel2 = this.createButtonPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.add(SwingFactory.newOkButton(new CodeBlock((Object)this, "ok")));
        jPanel.add(SwingFactory.newCancelButton(new CodeBlock((Object)this, "cancel")));
        Bundle.ARCH_MAP.injectComponents("FontChooserDialog.", jPanel);
        return jPanel;
    }
}

