/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.SwingFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class FontChooserPanel
extends JPanel {
    public static final String[] SIZES = new String[]{"9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "28", "36", "48", "72"};
    private JList m_FontList;
    private JList m_SizeList;
    private JCheckBox m_Bold;
    private JCheckBox m_Italic;

    public FontChooserPanel(Font font) {
        this.setLayout(new BorderLayout());
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Object[] objectArray = graphicsEnvironment.getAvailableFontFamilyNames();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.m_FontList = SwingFactory.newList(objectArray);
        jPanel.add((Component)new JLabel(Bundle.ARCH.getString("FontChooserPanel.FONT")), "North");
        jPanel.add((Component)new JScrollPane(this.m_FontList), "Center");
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.m_SizeList = SwingFactory.newList(SIZES);
        jPanel2.add((Component)new JLabel(Bundle.ARCH.getString("FontChooserPanel.SIZE")), "North");
        jPanel2.add((Component)new JScrollPane(this.m_SizeList), "Center");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        this.m_Bold = new JCheckBox(Bundle.ARCH.getString("FontChooserPanel.BOLD"));
        this.m_Italic = new JCheckBox(Bundle.ARCH.getString("FontChooserPanel.ITALIC"));
        jPanel3.add(this.m_Bold);
        jPanel3.add(this.m_Italic);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)jPanel2, "Center");
        jPanel4.add((Component)jPanel3, "South");
        this.add((Component)jPanel4, "East");
        this.setSelectedFont(font);
    }

    public Font getSelectedFont() {
        return new Font(this.getSelectedName(), this.getSelectedStyle(), this.getSelectedSize());
    }

    public String getSelectedName() {
        return (String)this.m_FontList.getSelectedValue();
    }

    public int getSelectedStyle() {
        if (this.m_Bold.isSelected() && this.m_Italic.isSelected()) {
            return 3;
        }
        if (this.m_Bold.isSelected()) {
            return 1;
        }
        if (this.m_Italic.isSelected()) {
            return 2;
        }
        return 0;
    }

    public int getSelectedSize() {
        String string = (String)this.m_SizeList.getSelectedValue();
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 10;
    }

    public void setSelectedFont(Font font) {
        if (font == null) {
            throw new NullPointerException();
        }
        this.m_Bold.setSelected(font.isBold());
        this.m_Italic.setSelected(font.isItalic());
        String string = font.getName();
        this.m_FontList.clearSelection();
        this.m_FontList.setSelectedValue(string, true);
        String string2 = String.valueOf(font.getSize());
        this.m_SizeList.clearSelection();
        this.m_SizeList.setSelectedValue(string2, true);
    }
}

