/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class FontMeasurer {
    private FontRenderContext m_FRC;
    private static FontMeasurer TT;
    private static FontMeasurer FF;
    private static FontMeasurer TF;
    private static FontMeasurer FT;

    public static FontMeasurer get(boolean bl, boolean bl2) {
        if (bl) {
            return bl2 ? TT : TF;
        }
        return bl2 ? FT : FF;
    }

    private FontMeasurer(AffineTransform affineTransform, boolean bl, boolean bl2) {
        this.m_FRC = new FontRenderContext(affineTransform, false, false);
    }

    public float getWidth(Font font, String string) {
        Rectangle2D rectangle2D = font.getStringBounds(string, this.m_FRC);
        return (float)rectangle2D.getWidth();
    }

    public float getHeight(Font font) {
        return font.getLineMetrics("Dummy", this.m_FRC).getHeight();
    }

    public float getAscent(Font font) {
        return font.getLineMetrics("Dummy", this.m_FRC).getAscent();
    }

    public float getDescent(Font font) {
        return font.getLineMetrics("Dummy", this.m_FRC).getDescent();
    }

    public Rectangle2D getBounds(Font font, String string) {
        return font.getStringBounds(string, this.m_FRC);
    }

    public LineMetrics getLineMetrics(Font font, String string) {
        return font.getLineMetrics(string, this.m_FRC);
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            AffineTransform affineTransform = graphicsConfiguration.getDefaultTransform();
            TT = new FontMeasurer(affineTransform, true, true);
            FF = new FontMeasurer(affineTransform, false, false);
            TF = new FontMeasurer(affineTransform, true, false);
            FT = new FontMeasurer(affineTransform, false, true);
        }
    }
}

