/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.ui.ChartUIMessages;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import com.elixirtech.util.format.IFormat;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class FormatPanel
extends JPanel {
    public static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(FormatPanel.class);
    private final Class<? extends IFormat> m_FormatClass;
    private Options m_Options;
    private Builder m_Details;
    private Pattern m_Pattern;
    private NumberPanel m_NumberPanel;
    private DateTimePanel m_DateTimePanel;
    private CodeBlock m_Mediator;
    private static final String[] TYPE_NAMES = new String[]{"None", "Currency", "Percent", "Percent100", "Number", "Date/Time"};
    private static final String[] NAMES = new String[]{ChartUIMessages.getString("FormatPanel.NONE"), ChartUIMessages.getString("FormatPanel.CURRENCY"), ChartUIMessages.getString("FormatPanel.PERCENT"), ChartUIMessages.getString("FormatPanel.PERCENT100"), ChartUIMessages.getString("FormatPanel.NUMBER"), ChartUIMessages.getString("FormatPanel.DATE_TIME")};
    private static final String[] PANEL_TYPES = new String[]{"None", "Number", "Number", "Number", "Number", "DateTime"};
    private static final String INT_LABEL = "int-label";
    private static final String INT_MIN_LABEL = "int-min-label";
    private static final String INT_MIN = "int-min";
    private static final String INT_MAX_LABEL = "int-max-label";
    private static final String INT_MAX = "int-max";
    private static final String FRAC_LABEL = "frac-label";
    private static final String FRAC_MIN_LABEL = "frac-min-label";
    private static final String FRAC_MIN = "frac-min";
    private static final String FRAC_MAX_LABEL = "frac-max-label";
    private static final String FRAC_MAX = "frac-max";
    private static final String GSZ_LABEL = "gsz-label";
    private static final String GSZ = "gsz";
    private static final String GUSED_LABEL = "gused-label";
    private static final String GUSED = "gused";
    private static final String DEC_LABEL = "dec-label";
    private static final String DEC = "dec";
    private static final String[] CHOICES = new String[]{"None", "Full", "Short", "Medium", "Long"};
    static final String[] KEYS = new String[]{"Format.NONE", "Format.FULL", "Format.SHORT", "Format.MEDIUM", "Format.LONG"};
    private static final String DATE = "date";
    private static final String DATE_LABEL = "date-label";
    private static final String TIME = "time";
    private static final String TIME_LABEL = "time-label";
    private static final String LABELS = "date-label,time-label";
    private static final String CUSTOM = "custom";
    private static final String PATTERN = "pattern";
    private static final String SAMPLE_LABEL = "sample-label";
    private static final String SAMPLE = "sample";

    public FormatPanel(Class<? extends IFormat> clazz) {
        this.m_FormatClass = clazz;
        this.setLayout(new BorderLayout());
        this.m_Mediator = new CodeBlock((Object)this, "update");
        this.m_Options = new Options();
        this.m_Details = new Builder();
        this.m_Pattern = new Pattern();
        this.add((Component)this.m_Options, "North");
        this.add((Component)this.m_Details, "Center");
        this.add((Component)this.m_Pattern, "South");
    }

    protected IFormat createFormat() {
        try {
            return this.m_FormatClass.newInstance();
        }
        catch (Throwable throwable) {
            m_Log.error((Object)"Error creating format", throwable);
            throw new RuntimeException("Error creating format");
        }
    }

    public void setFormat(IFormat iFormat) {
        if (iFormat != null) {
            this.m_Options.setType(iFormat.getType());
            String string = iFormat.getCustomPattern();
            if (StringUtil.notEmpty(string)) {
                this.m_NumberPanel.setDefault();
                this.m_DateTimePanel.setDefault();
                this.m_Pattern.setFormat(iFormat);
            } else {
                this.m_NumberPanel.setFormat(iFormat);
                this.m_DateTimePanel.setFormat(iFormat);
                this.m_Pattern.setFormat(iFormat);
            }
        } else {
            this.m_NumberPanel.setDefault();
            this.m_DateTimePanel.setDefault();
            this.m_Pattern.setValues(null, null);
        }
        this.update();
    }

    public IFormat getFormat() {
        int n = this.m_Options.getTypeIndex();
        if (n == 0) {
            return null;
        }
        IFormat iFormat = this.createFormat();
        iFormat.setType(TYPE_NAMES[n]);
        if (this.m_Pattern.isCustom()) {
            iFormat.setCustomPattern(this.m_Pattern.getPattern());
        } else if (this.isNumberPanel()) {
            this.m_NumberPanel.getFormat(iFormat);
        } else if (this.isDateTimePanel()) {
            this.m_DateTimePanel.getFormat(iFormat);
        }
        return iFormat;
    }

    public void update() {
        this.m_Pattern.m_PatternField.getDocument().removeDocumentListener(this.m_Mediator);
        int n = this.m_Options.getTypeIndex();
        this.m_Details.showCard(PANEL_TYPES[n]);
        this.m_Pattern.showContents(n != 0);
        if (this.m_Pattern.isCustom()) {
            this.m_NumberPanel.setEnabled(false);
            this.m_DateTimePanel.setEnabled(false);
            this.m_Pattern.m_PatternField.setEnabled(true);
            this.m_Pattern.m_Sample.setText(this.getSample(this.m_Pattern.getPattern()));
        } else {
            this.m_NumberPanel.setEnabled(true);
            this.m_DateTimePanel.setEnabled(true);
            this.m_Pattern.m_PatternField.setEnabled(false);
            if (this.isNumberPanel()) {
                this.m_NumberPanel.update();
            } else if (this.isDateTimePanel()) {
                this.m_DateTimePanel.update();
            }
        }
        if (this.m_Pattern.isCustom()) {
            this.m_Pattern.m_PatternField.getDocument().addDocumentListener(this.m_Mediator);
        }
    }

    protected String getSample(String string) {
        if (this.isNumberPanel()) {
            return this.m_NumberPanel.getSample(string);
        }
        if (this.isDateTimePanel()) {
            return this.m_DateTimePanel.getSample(string);
        }
        return null;
    }

    protected void refreshPattern() {
        if (this.isNumberPanel()) {
            this.m_NumberPanel.update();
        } else if (this.isDateTimePanel()) {
            this.m_DateTimePanel.update();
        }
    }

    private boolean isNumberPanel() {
        int n = this.m_Options.getTypeIndex();
        return "Number".equals(PANEL_TYPES[n]);
    }

    private boolean isDateTimePanel() {
        int n = this.m_Options.getTypeIndex();
        return "DateTime".equals(PANEL_TYPES[n]);
    }

    private class Options
    extends JPanel {
        private JComboBox m_Type;

        public Options() {
            this.setLayout(new FlowLayout(0));
            this.add(new JLabel(ChartUIMessages.getString("FormatPanel.FORMAT_TYPE")));
            this.m_Type = new JComboBox<String>(NAMES);
            this.add(this.m_Type);
            this.m_Type.addItemListener(FormatPanel.this.m_Mediator);
        }

        public void setType(String string) {
            for (int i = 0; i < TYPE_NAMES.length; ++i) {
                if (!TYPE_NAMES[i].equals(string)) continue;
                this.m_Type.setSelectedIndex(i);
                break;
            }
        }

        public String getType() {
            return TYPE_NAMES[this.m_Type.getSelectedIndex()];
        }

        public int getTypeIndex() {
            return this.m_Type.getSelectedIndex();
        }
    }

    private class Builder
    extends JPanel {
        private CardLayout m_Layout = new CardLayout();

        public Builder() {
            this.setLayout(this.m_Layout);
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            JPanel jPanel = new JPanel();
            FormatPanel.this.m_NumberPanel = new NumberPanel();
            FormatPanel.this.m_DateTimePanel = new DateTimePanel();
            this.add("None", jPanel);
            this.add("Number", FormatPanel.this.m_NumberPanel);
            this.add("DateTime", FormatPanel.this.m_DateTimePanel);
        }

        public void showCard(String string) {
            this.m_Layout.show(this, string);
        }
    }

    private class Pattern
    extends JPanel {
        private ArchLayout m_Layout;
        private JPanel m_Contents;
        private JCheckBox m_Custom;
        private JTextField m_PatternField;
        private JLabel m_Sample;

        public Pattern() {
            this.setLayout(new BorderLayout());
            this.m_Layout = new ArchLayout();
            this.m_Contents = new JPanel(this.m_Layout);
            this.m_Contents.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)this.m_Contents, "Center");
            this.m_Custom = new JCheckBox(ChartUIMessages.getString("FormatPanel.CUSTOM_PATTERN"));
            this.m_Custom.addItemListener(FormatPanel.this.m_Mediator);
            this.m_PatternField = new JTextField();
            this.m_PatternField.setEnabled(false);
            this.m_Sample = new JLabel();
            this.m_Sample.setBorder(BorderFactory.createEtchedBorder());
            this.m_Contents.add(FormatPanel.CUSTOM, this.m_Custom);
            this.m_Contents.add(FormatPanel.PATTERN, this.m_PatternField);
            this.m_Contents.add(FormatPanel.SAMPLE_LABEL, new JLabel(ChartUIMessages.getString("FormatPanel.SAMPLE")));
            this.m_Contents.add(FormatPanel.SAMPLE, this.m_Sample);
            this.m_Layout.stickTop(FormatPanel.PATTERN);
            this.m_Layout.putRight(FormatPanel.PATTERN, FormatPanel.CUSTOM, 10);
            this.m_Layout.stickLeft(FormatPanel.CUSTOM);
            this.m_Layout.vCenter(FormatPanel.CUSTOM, FormatPanel.PATTERN);
            this.m_Layout.stickLeft(FormatPanel.SAMPLE_LABEL);
            this.m_Layout.vCenter(FormatPanel.SAMPLE_LABEL, FormatPanel.SAMPLE);
            this.m_Layout.putBelow(FormatPanel.SAMPLE, FormatPanel.PATTERN, 10);
            this.m_Layout.putRight(FormatPanel.SAMPLE, FormatPanel.SAMPLE_LABEL, 10);
            this.m_Layout.stickRight(FormatPanel.PATTERN);
            this.m_Layout.stickRight(FormatPanel.SAMPLE);
            this.m_Layout.setHeight(FormatPanel.SAMPLE, FormatPanel.PATTERN);
            this.setPreferredSize(this.m_Contents.getPreferredSize());
        }

        public void showContents(boolean bl) {
            this.m_Contents.setVisible(bl);
        }

        public void setFormat(IFormat iFormat) {
            String string = iFormat.getCustomPattern();
            if (StringUtil.notEmpty(string)) {
                this.m_Custom.setSelected(true);
                this.m_PatternField.setText(string);
            }
        }

        public boolean isCustom() {
            return this.m_Custom.isSelected();
        }

        public void setValues(String string, String string2) {
            if (!this.isCustom()) {
                this.m_PatternField.setText(string);
            }
            this.m_Sample.setText(string2);
        }

        public String getPattern() {
            return this.m_PatternField.getText();
        }
    }

    private class NumberPanel
    extends JPanel {
        private ArchLayout m_Layout;
        private JSpinner m_MinInt = new JSpinner(new SpinnerNumberModel(1, 0, 300, 1));
        private JSpinner m_MaxInt = new JSpinner(new SpinnerNumberModel(10, 0, 300, 1));
        private JSpinner m_MinFrac = new JSpinner(new SpinnerNumberModel(2, 0, 300, 1));
        private JSpinner m_MaxFrac = new JSpinner(new SpinnerNumberModel(2, 0, 300, 1));
        private JSpinner m_GroupingSize = new JSpinner(new SpinnerNumberModel(3, 1, 300, 1));
        private JCheckBox m_GroupingUsed = new JCheckBox();
        private JCheckBox m_DecimalSeparatorAlwaysShown = new JCheckBox();

        public NumberPanel() {
            this.m_Layout = new ArchLayout();
            this.setLayout(this.m_Layout);
            this.add(FormatPanel.INT_LABEL, new JLabel(ChartUIMessages.getString("FormatPanel.INTEGER_PLACES")));
            this.add(FormatPanel.INT_MIN_LABEL, new JLabel(ChartUIMessages.getString("FormatPanel.MIN")));
            this.add(FormatPanel.INT_MIN, this.m_MinInt);
            this.add(FormatPanel.INT_MAX_LABEL, new JLabel(ChartUIMessages.getString("FormatPanel.MAX")));
            this.add(FormatPanel.INT_MAX, this.m_MaxInt);
            this.add(FormatPanel.FRAC_LABEL, new JLabel(ChartUIMessages.getString("FormatPanel.FRACTIONAL_PLACES")));
            this.add(FormatPanel.FRAC_MIN_LABEL, new JLabel(ChartUIMessages.getString("FormatPanel.MIN")));
            this.add(FormatPanel.FRAC_MIN, this.m_MinFrac);
            this.add(FormatPanel.FRAC_MAX_LABEL, new JLabel(ChartUIMessages.getString("FormatPanel.MAX")));
            this.add(FormatPanel.FRAC_MAX, this.m_MaxFrac);
            this.add(FormatPanel.GSZ_LABEL, new JLabel(ChartUIMessages.getString("FormatPanel.GROUPING_SIZE")));
            this.add(FormatPanel.GSZ, this.m_GroupingSize);
            this.add(FormatPanel.GUSED_LABEL, new JLabel(ChartUIMessages.getString("FormatPanel.SHOW_GROUP_SEPARATOR")));
            this.add(FormatPanel.GUSED, this.m_GroupingUsed);
            this.add(FormatPanel.DEC_LABEL, new JLabel(ChartUIMessages.getString("FormatPanel.ALWAYS_SHOW_DECIMAL_SEPARATOR")));
            this.add(FormatPanel.DEC, this.m_DecimalSeparatorAlwaysShown);
            this.m_Layout.stickLeft(FormatPanel.INT_LABEL);
            this.m_Layout.vCenter(FormatPanel.INT_LABEL, FormatPanel.INT_MIN);
            this.m_Layout.vCenter(FormatPanel.INT_MIN_LABEL, FormatPanel.INT_MIN);
            this.m_Layout.vCenter(FormatPanel.INT_MAX_LABEL, FormatPanel.INT_MIN);
            this.m_Layout.vCenter(FormatPanel.INT_MAX, FormatPanel.INT_MIN);
            this.m_Layout.stickTop(FormatPanel.INT_MIN);
            this.m_Layout.putRight(FormatPanel.INT_MIN, "int-label,frac-label,gsz-label,gused-label,dec-label", 10);
            this.m_Layout.putRight(FormatPanel.INT_MAX_LABEL, FormatPanel.INT_MIN, 10);
            this.m_Layout.putRight(FormatPanel.INT_MAX, FormatPanel.INT_MAX_LABEL, 10);
            this.m_Layout.putLeft(FormatPanel.INT_MIN_LABEL, FormatPanel.INT_MIN, -10);
            this.m_Layout.stickLeft(FormatPanel.FRAC_LABEL);
            this.m_Layout.vCenter(FormatPanel.FRAC_LABEL, FormatPanel.FRAC_MIN);
            this.m_Layout.vCenter(FormatPanel.FRAC_MIN_LABEL, FormatPanel.FRAC_MIN);
            this.m_Layout.vCenter(FormatPanel.FRAC_MAX_LABEL, FormatPanel.FRAC_MIN);
            this.m_Layout.vCenter(FormatPanel.FRAC_MAX, FormatPanel.FRAC_MIN);
            this.m_Layout.putLeft(FormatPanel.FRAC_MIN_LABEL, FormatPanel.FRAC_MIN, -10);
            this.m_Layout.alignBelow(FormatPanel.FRAC_MIN, FormatPanel.INT_MIN);
            this.m_Layout.alignBelow(FormatPanel.FRAC_MAX_LABEL, FormatPanel.INT_MAX_LABEL);
            this.m_Layout.alignBelow(FormatPanel.FRAC_MAX, FormatPanel.INT_MAX);
            this.m_Layout.stickLeft(FormatPanel.GUSED_LABEL);
            this.m_Layout.vCenter(FormatPanel.GUSED_LABEL, FormatPanel.GUSED);
            this.m_Layout.alignBelow(FormatPanel.GUSED, FormatPanel.FRAC_MIN);
            this.m_Layout.stickLeft(FormatPanel.GSZ_LABEL);
            this.m_Layout.vCenter(FormatPanel.GSZ_LABEL, FormatPanel.GSZ);
            this.m_Layout.alignBelow(FormatPanel.GSZ, FormatPanel.GUSED);
            this.m_Layout.stickLeft(FormatPanel.DEC_LABEL);
            this.m_Layout.vCenter(FormatPanel.DEC_LABEL, FormatPanel.DEC);
            this.m_Layout.alignBelow(FormatPanel.DEC, FormatPanel.GSZ);
            this.m_MinInt.getModel().addChangeListener(FormatPanel.this.m_Mediator);
            this.m_MaxInt.getModel().addChangeListener(FormatPanel.this.m_Mediator);
            this.m_MinFrac.getModel().addChangeListener(FormatPanel.this.m_Mediator);
            this.m_MaxFrac.getModel().addChangeListener(FormatPanel.this.m_Mediator);
            this.m_GroupingSize.getModel().addChangeListener(FormatPanel.this.m_Mediator);
            this.m_GroupingUsed.addItemListener(FormatPanel.this.m_Mediator);
            this.m_DecimalSeparatorAlwaysShown.addItemListener(FormatPanel.this.m_Mediator);
        }

        public void setFormat(IFormat iFormat) {
            this.m_MinInt.setValue(iFormat.getMinIntegerDigits());
            this.m_MaxInt.setValue(iFormat.getMaxIntegerDigits());
            this.m_MinFrac.setValue(iFormat.getMinFractionDigits());
            this.m_MaxFrac.setValue(iFormat.getMaxFractionDigits());
            this.m_GroupingSize.setValue(iFormat.getGroupingSize());
            this.m_GroupingUsed.setSelected(iFormat.isGroupingUsed());
            this.m_DecimalSeparatorAlwaysShown.setSelected(iFormat.isDecimalSeparatorAlwaysShown());
        }

        public void setDefault() {
            this.m_MinInt.setValue(1);
            this.m_MaxInt.setValue(10);
            this.m_MinFrac.setValue(2);
            this.m_MaxFrac.setValue(2);
            this.m_GroupingSize.setValue(3);
            this.m_GroupingUsed.setSelected(true);
            this.m_DecimalSeparatorAlwaysShown.setSelected(true);
        }

        public void getFormat(IFormat iFormat) {
            iFormat.setMinIntegerDigits(((Number)this.m_MinInt.getValue()).intValue());
            iFormat.setMaxIntegerDigits(((Number)this.m_MaxInt.getValue()).intValue());
            iFormat.setMinFractionDigits(((Number)this.m_MinFrac.getValue()).intValue());
            iFormat.setMaxFractionDigits(((Number)this.m_MaxFrac.getValue()).intValue());
            iFormat.setGroupingSize(((Number)this.m_GroupingSize.getValue()).intValue());
            iFormat.setGroupingUsed(this.m_GroupingUsed.isSelected());
            iFormat.setDecimalSeparatorAlwaysShown(this.m_DecimalSeparatorAlwaysShown.isSelected());
        }

        public void update() {
            int n = FormatPanel.this.m_Options.getTypeIndex();
            IFormat iFormat = FormatPanel.this.createFormat();
            iFormat.setType(TYPE_NAMES[n]);
            FormatPanel.this.m_NumberPanel.getFormat(iFormat);
            NumberFormat numberFormat = this.getNumberFormat();
            if (numberFormat != null) {
                String string = ((DecimalFormat)numberFormat).toPattern();
                String string2 = numberFormat.format(123456.7890123) + "  " + numberFormat.format(-123456.7890123);
                FormatPanel.this.m_Pattern.setValues(string, string2);
            }
        }

        public String getSample(String string) {
            try {
                DecimalFormat decimalFormat = new DecimalFormat(string);
                String string2 = decimalFormat.format(123456.7890123) + "  " + decimalFormat.format(-123456.7890123);
                return string2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                m_Log.error((Object)("Unable to format String pattern, " + illegalArgumentException.getMessage()));
                return "";
            }
        }

        public NumberFormat getNumberFormat() {
            int n = FormatPanel.this.m_Options.getTypeIndex();
            IFormat iFormat = FormatPanel.this.createFormat();
            iFormat.setType(TYPE_NAMES[n]);
            FormatPanel.this.m_NumberPanel.getFormat(iFormat);
            NumberFormat numberFormat = null;
            if (n == 1) {
                numberFormat = NumberFormat.getCurrencyInstance();
            }
            if (n == 2) {
                numberFormat = NumberFormat.getPercentInstance();
            }
            if (n == 3) {
                numberFormat = NumberFormat.getPercentInstance();
            }
            if (n == 4) {
                numberFormat = NumberFormat.getNumberInstance();
            }
            if (numberFormat != null) {
                this.configNumberFormatter(numberFormat, iFormat);
            }
            return numberFormat;
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].setEnabled(bl);
            }
        }

        private void configNumberFormatter(NumberFormat numberFormat, IFormat iFormat) {
            numberFormat.setMinimumIntegerDigits(iFormat.getMinIntegerDigits());
            numberFormat.setMaximumIntegerDigits(iFormat.getMaxIntegerDigits());
            numberFormat.setMinimumFractionDigits(iFormat.getMinFractionDigits());
            numberFormat.setMaximumFractionDigits(iFormat.getMaxFractionDigits());
            numberFormat.setGroupingUsed(iFormat.isGroupingUsed());
            if (numberFormat instanceof DecimalFormat) {
                ((DecimalFormat)numberFormat).setGroupingSize(iFormat.getGroupingSize());
                ((DecimalFormat)numberFormat).setDecimalSeparatorAlwaysShown(iFormat.isDecimalSeparatorAlwaysShown());
            }
        }
    }

    public class DateTimePanel
    extends JPanel {
        private ArchLayout m_Layout;
        private I18NComboBox m_DateCombo = I18NComboBox.apply(I18NComboBox.buildNames(CHOICES, ChartUIMessages.ERD, KEYS));
        private I18NComboBox m_TimeCombo = I18NComboBox.apply(I18NComboBox.buildNames(CHOICES, ChartUIMessages.ERD, KEYS));

        public DateTimePanel() {
            this.m_Layout = new ArchLayout();
            this.setLayout(this.m_Layout);
            this.add(FormatPanel.DATE_LABEL, new JLabel(ChartUIMessages.getString("FormatPanel.DATE_FORMAT")));
            this.add(FormatPanel.DATE, this.m_DateCombo);
            this.add(FormatPanel.TIME_LABEL, new JLabel(ChartUIMessages.getString("FormatPanel.TIME_FORMAT")));
            this.add(FormatPanel.TIME, this.m_TimeCombo);
            this.m_Layout.stickTop(FormatPanel.DATE);
            this.m_Layout.stickLeft(FormatPanel.DATE_LABEL);
            this.m_Layout.vCenter(FormatPanel.DATE_LABEL, FormatPanel.DATE);
            this.m_Layout.putRight(FormatPanel.DATE, FormatPanel.LABELS, 10);
            this.m_Layout.stickLeft(FormatPanel.TIME_LABEL);
            this.m_Layout.vCenter(FormatPanel.TIME_LABEL, FormatPanel.TIME);
            this.m_Layout.alignBelow(FormatPanel.TIME, FormatPanel.DATE);
            this.m_DateCombo.addItemListener(FormatPanel.this.m_Mediator);
            this.m_TimeCombo.addItemListener(FormatPanel.this.m_Mediator);
        }

        public void setFormat(IFormat iFormat) {
            this.m_DateCombo.setSelectedId(iFormat.getDateFormat());
            this.m_TimeCombo.setSelectedId(iFormat.getTimeFormat());
        }

        public void setDefault() {
            this.m_DateCombo.setSelectedId("Short");
            this.m_TimeCombo.setSelectedId("Short");
        }

        public void getFormat(IFormat iFormat) {
            iFormat.setDateFormat(this.m_DateCombo.getSelectedId());
            iFormat.setTimeFormat(this.m_TimeCombo.getSelectedId());
        }

        public void update() {
            String string = null;
            String string2 = null;
            DateFormat dateFormat = this.getDateFormat();
            if (dateFormat != null) {
                string = ((SimpleDateFormat)dateFormat).toPattern();
                string2 = dateFormat.format(new Date());
            }
            FormatPanel.this.m_Pattern.setValues(string, string2);
        }

        public DateFormat getDateFormat() {
            Locale locale = Locale.getDefault();
            int n = this.getStyle(this.m_DateCombo.getSelectedId());
            int n2 = this.getStyle(this.m_TimeCombo.getSelectedId());
            DateFormat dateFormat = null;
            if (n == -1) {
                if (n2 != -1) {
                    dateFormat = DateFormat.getTimeInstance(n2, locale);
                }
            } else {
                dateFormat = n2 == -1 ? DateFormat.getDateInstance(n, locale) : DateFormat.getDateTimeInstance(n, n2, locale);
            }
            return dateFormat;
        }

        public String getSample(String string) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            return simpleDateFormat.format(new Date());
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                componentArray[i].setEnabled(bl);
            }
        }

        private int getStyle(String string) {
            if (string == null || string.equals("None")) {
                return -1;
            }
            if (string.equals("Full")) {
                return 0;
            }
            if (string.equals("Long")) {
                return 1;
            }
            if (string.equals("Medium")) {
                return 2;
            }
            if (string.equals("Short")) {
                return 3;
            }
            return 3;
        }
    }
}

