/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GlassPanelPopupManager
extends JPanel {
    private Component m_Receiver;
    private PopupListener m_Listener;
    private Component m_DownComponent;

    public GlassPanelPopupManager(Component component, PopupListener popupListener) {
        this.m_Receiver = component;
        this.enableEvents(48L);
        this.m_Listener = popupListener;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.m_Listener.doPopup(mouseEvent);
        } else {
            this.dispatch(mouseEvent);
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.dispatch(mouseEvent);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
    }

    private void dispatch(MouseEvent mouseEvent) {
        Component component = null;
        if (mouseEvent.getID() == 501) {
            this.m_DownComponent = SwingUtilities.getDeepestComponentAt(this.m_Receiver, mouseEvent.getX(), mouseEvent.getY());
        }
        if ((component = this.m_DownComponent != null ? this.m_DownComponent : SwingUtilities.getDeepestComponentAt(this.m_Receiver, mouseEvent.getX(), mouseEvent.getY())) != null) {
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent((Component)mouseEvent.getSource(), mouseEvent, component);
            this.setCursor(component.getCursor());
            component.dispatchEvent(mouseEvent2);
        }
        if (mouseEvent.getID() == 502) {
            this.m_DownComponent = null;
        }
    }

    public static interface PopupListener {
        public void doPopup(MouseEvent var1);
    }
}

