/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IThrobber;

public final class InfiniteThrobber
extends Thread {
    private static final int THROB_INTERVAL = 500;
    private final IThrobber m_Throbber;
    private int m_OngoingRequests;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(InfiniteThrobber.class);

    public InfiniteThrobber(IThrobber iThrobber) {
        this.m_Throbber = iThrobber;
        this.setDaemon(true);
        this.start();
    }

    public synchronized void addThrob() {
        ++this.m_OngoingRequests;
        if (this.m_OngoingRequests == 1) {
            this.notify();
        }
    }

    public synchronized void removeThrob() {
        if (this.m_OngoingRequests > 0) {
            --this.m_OngoingRequests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                int n;
                if ((n = this.getValue()) == 0) {
                    InfiniteThrobber infiniteThrobber = this;
                    synchronized (infiniteThrobber) {
                        this.m_Throbber.resetThrobber();
                        this.wait();
                    }
                    n = this.getValue();
                }
                if (n <= 0) continue;
                this.m_Throbber.updateThrobber();
                InfiniteThrobber.sleep(500L);
            }
        }
        catch (InterruptedException interruptedException) {
            m_Log.warn((Object)"Infinite Throbber interrupted");
            return;
        }
    }

    private synchronized int getValue() {
        return this.m_OngoingRequests;
    }
}

