/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ItemSelectionButton
extends JLabel {
    private boolean m_Selected;
    private List<ActionListener> m_Listeners = new ArrayList<ActionListener>();
    private static Color SEL_BG = new Color(57, 105, 138);

    public ItemSelectionButton(String string) {
        this();
        this.setText(string);
    }

    public ItemSelectionButton() {
        this.setOpaque(true);
        Border border = BorderFactory.createBevelBorder(0);
        Border border2 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.setBorder(BorderFactory.createCompoundBorder(border, border2));
        this.setHorizontalAlignment(0);
        this.setFont(UIManager.getFont("Table.font"));
        this.enableEvents(16L);
        this.stateChanged();
    }

    public void disableEvents() {
        super.disableEvents(16L);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.enableEvents(16L);
        } else {
            this.disableEvents(16L);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_Listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_Listeners.remove(actionListener);
    }

    public void setSelected(boolean bl) {
        if (this.m_Selected != bl) {
            this.m_Selected = bl;
            this.stateChanged();
            this.repaint();
        }
    }

    public boolean isSelected() {
        return this.m_Selected;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getID() == 501) {
            this.toggleSelected();
        }
    }

    protected void toggleSelected() {
        this.m_Selected = !this.m_Selected;
        this.stateChanged();
        this.repaint();
        ActionEvent actionEvent = new ActionEvent(this, 1001, "clicked");
        ArrayList<ActionListener> arrayList = new ArrayList<ActionListener>();
        arrayList.addAll(this.m_Listeners);
        for (ActionListener actionListener : arrayList) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    protected void stateChanged() {
        Color color = this.m_Selected ? SEL_BG : null;
        Color color2 = this.m_Selected ? Color.WHITE : Color.BLACK;
        this.setBackground(color);
        this.setForeground(color2);
    }
}

