/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.ItemSelectionButton;
import com.elixirtech.ui.SwingFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ItemSelectionPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -3867526461383562380L;
    private JPanel m_LegendPanel;
    private JPanel m_ButtonPanel;
    private Map<String, ItemSelectionButton> m_Buttons = new HashMap<String, ItemSelectionButton>();
    private List<String> m_Items;
    private Set<String> m_SelectedItems = new HashSet<String>();
    private boolean m_IsDirty;

    public ItemSelectionPanel(List<String> list, int n, int n2, boolean bl) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.addButtons(list, n, n2);
        if (bl) {
            this.addLegend();
        }
    }

    public void initSelectedItems(Set<String> set) {
        this.m_SelectedItems = set;
        for (String string : this.m_Items) {
            ItemSelectionButton itemSelectionButton = this.m_Buttons.get(string);
            itemSelectionButton.setSelected(this.m_SelectedItems.contains(string));
        }
        this.m_IsDirty = false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ItemSelectionButton itemSelectionButton = (ItemSelectionButton)actionEvent.getSource();
        String string = itemSelectionButton.getName();
        if (itemSelectionButton.isSelected()) {
            this.m_SelectedItems.add(string);
        } else {
            this.m_SelectedItems.remove(string);
        }
        this.m_IsDirty = true;
    }

    public Set<String> getSelectedItems() {
        return this.m_SelectedItems;
    }

    public boolean isDirty() {
        return this.m_IsDirty;
    }

    private void addButtons(List<String> list, int n, int n2) {
        this.m_Items = list;
        this.m_ButtonPanel = new JPanel(new GridLayout(n, n2, 0, 0));
        this.m_ButtonPanel.setName("buttons");
        this.m_ButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        for (String object2 : list) {
            ItemSelectionButton itemSelectionButton = new ItemSelectionButton(object2);
            itemSelectionButton.setName(object2);
            itemSelectionButton.addActionListener(this);
            this.m_ButtonPanel.add(itemSelectionButton);
            this.m_Buttons.put(object2, itemSelectionButton);
        }
        JLabel jLabel = new JLabel(Bundle.ARCH_MAP.getString("ItemSelectionPanel.HelpMessage"));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add(this.m_ButtonPanel);
        jPanel.add((Component)new SelectionActions(), "South");
        this.add(jPanel);
    }

    private void addLegend() {
        this.m_LegendPanel = new JPanel();
        this.m_LegendPanel.setName("legend");
        this.m_LegendPanel.setBorder(BorderFactory.createTitledBorder(Bundle.ARCH_MAP.getString("ItemSelectionPanel.Legend.Title")));
        ArchLayout archLayout = new ArchLayout();
        this.m_LegendPanel.setLayout(archLayout);
        JLabel jLabel = new JLabel(Bundle.ARCH_MAP.getString("ItemSelectionPanel.Legend.Selected"));
        jLabel.setName("legend-selected");
        JLabel jLabel2 = new JLabel(Bundle.ARCH_MAP.getString("ItemSelectionPanel.Legend.NotSelected"));
        jLabel2.setName("legend-not-selected");
        ItemSelectionButton itemSelectionButton = new ItemSelectionButton();
        itemSelectionButton.disableEvents();
        itemSelectionButton.setName("selected-button");
        itemSelectionButton.setPreferredSize(new Dimension(20, 20));
        itemSelectionButton.setSelected(true);
        ItemSelectionButton itemSelectionButton2 = new ItemSelectionButton();
        itemSelectionButton2.disableEvents();
        itemSelectionButton2.setName("not-selected-button");
        itemSelectionButton2.setPreferredSize(new Dimension(20, 20));
        this.m_LegendPanel.add(itemSelectionButton);
        this.m_LegendPanel.add(itemSelectionButton2);
        this.m_LegendPanel.add(jLabel);
        this.m_LegendPanel.add(jLabel2);
        archLayout.stickTop("selected-button");
        archLayout.stickLeft("selected-button");
        archLayout.putRight("legend-selected", "selected-button", 5);
        archLayout.stickTop("legend-selected");
        archLayout.stickLeft("not-selected-button");
        archLayout.putBelow("not-selected-button", "selected-button", 5);
        archLayout.putBelow("legend-not-selected", "selected-button", 5);
        archLayout.putRight("legend-not-selected", "not-selected-button", 5);
        this.add((Component)this.m_LegendPanel, "West");
    }

    class SelectionActions
    extends JPanel
    implements ActionListener {
        private JButton m_SelectAll;
        private JButton m_SelectNone;
        private JButton m_SelectInverse;

        SelectionActions() {
            this.setName("select-actions");
            this.setLayout(new FlowLayout());
            JLabel jLabel = SwingFactory.newLabel("select");
            jLabel.setText(Bundle.ARCH_MAP.getString("Select"));
            this.m_SelectAll = SwingFactory.newButton("all", this);
            this.m_SelectNone = SwingFactory.newButton("none", this);
            this.m_SelectInverse = SwingFactory.newButton("inverse", this);
            this.add(jLabel);
            this.add(this.m_SelectAll);
            this.add(this.m_SelectNone);
            this.add(this.m_SelectInverse);
            this.m_SelectAll.setText(Bundle.ARCH_MAP.getString("All"));
            this.m_SelectNone.setText(Bundle.ARCH_MAP.getString("None"));
            this.m_SelectInverse.setText(Bundle.ARCH_MAP.getString("Inverse"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            Collection<ItemSelectionButton> collection = ItemSelectionPanel.this.m_Buttons.values();
            if (object == this.m_SelectAll) {
                for (ItemSelectionButton object2 : collection) {
                    object2.setSelected(true);
                }
                ItemSelectionPanel.this.m_IsDirty = true;
            } else if (object == this.m_SelectNone) {
                for (ItemSelectionButton itemSelectionButton : collection) {
                    itemSelectionButton.setSelected(false);
                }
                ItemSelectionPanel.this.m_IsDirty = true;
            } else if (object == this.m_SelectInverse) {
                for (ItemSelectionButton itemSelectionButton : collection) {
                    itemSelectionButton.setSelected(!itemSelectionButton.isSelected());
                }
                ItemSelectionPanel.this.m_IsDirty = true;
            }
            if (ItemSelectionPanel.this.m_IsDirty) {
                ItemSelectionPanel.this.m_SelectedItems.clear();
                Collection<ItemSelectionButton> collection2 = ItemSelectionPanel.this.m_Buttons.values();
                Iterator iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    ItemSelectionButton itemSelectionButton = (ItemSelectionButton)iterator.next();
                    if (!itemSelectionButton.isSelected()) continue;
                    ItemSelectionPanel.this.m_SelectedItems.add(itemSelectionButton.getText());
                }
            }
        }
    }
}

