/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.util.StringUtil;
import java.io.File;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class JFileChooserEx
extends JFileChooser {
    private static String m_CurrentDirectory = System.getProperty("user.dir");

    public JFileChooserEx() {
        super(m_CurrentDirectory, FileSystemView.getFileSystemView());
        this.setFileSelectionMode(0);
    }

    public void setFilter(String string, String string2) {
        this.setFileFilter(new MyFileFilter(string, string2));
    }

    public void addFilter(String string, String string2) {
        this.addChoosableFileFilter(new MyFileFilter(string, string2));
    }

    @Override
    public File getSelectedFile() {
        File file = super.getSelectedFile();
        if (file != null) {
            m_CurrentDirectory = file.getParent();
        }
        return file;
    }

    @Override
    public File[] getSelectedFiles() {
        File[] fileArray = super.getSelectedFiles();
        if (fileArray.length > 0) {
            m_CurrentDirectory = fileArray[0].getParent();
        }
        return fileArray;
    }

    public String getFileFilterExtension() {
        FileFilter fileFilter = this.getFileFilter();
        if (fileFilter instanceof MyFileFilter) {
            return ((MyFileFilter)fileFilter).getExtension();
        }
        return null;
    }

    public static String getLastDirectory() {
        return m_CurrentDirectory;
    }

    public static void setLastDirectory(String string) {
        m_CurrentDirectory = string;
    }

    private static class MyFileFilter
    extends FileFilter {
        private String[] m_Extension;
        private String m_Description;

        public MyFileFilter(String string, String string2) {
            this.m_Extension = StringUtil.arrayOfSubstrings(string, '|');
            this.m_Description = string2;
        }

        public String getExtension() {
            return this.m_Extension[0];
        }

        public String[] getExtensions() {
            return this.m_Extension;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            for (int i = 0; i < this.m_Extension.length; ++i) {
                if (!file.getName().toLowerCase(Locale.ENGLISH).endsWith(this.m_Extension[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.m_Description;
        }
    }
}

