/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.ui.INavigation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JNavigationPanel
extends JPanel
implements ActionListener {
    public static final String BASE = "i18n/base";
    public static final String FIRST_PAGE = "FirstPage";
    public static final String PREVIOUS_PAGE = "PreviousPage";
    public static final String NEXT_PAGE = "NextPage";
    public static final String LAST_PAGE = "LastPage";
    public static final String GOTO_PAGE = "GotoPage";
    private INavigation m_Navigation;
    private JButton m_First;
    private JButton m_Previous;
    private JButton m_Next;
    private JButton m_Last;
    private JTextField m_Goto;
    private JLabel m_TotalPage;
    private ResourceBundle m_Bundle;

    public JNavigationPanel(INavigation iNavigation) {
        this(iNavigation, 0);
    }

    public JNavigationPanel(INavigation iNavigation, int n) {
        this.m_Navigation = iNavigation;
        this.setOpaque(false);
        this.loadResources();
        this.buildView(n);
        this.setStatus();
    }

    public INavigation getNavigation() {
        return this.m_Navigation;
    }

    void firstPage() {
        this.m_Navigation.first();
        this.m_Goto.setText(String.valueOf(this.m_Navigation.getPageNo()));
        this.setStatus();
    }

    void previousPage() {
        if (this.m_Navigation.previous()) {
            this.m_Goto.setText(String.valueOf(this.m_Navigation.getPageNo()));
            this.setStatus();
        }
    }

    void nextPage() {
        if (this.m_Navigation.next()) {
            this.m_Goto.setText(String.valueOf(this.m_Navigation.getPageNo()));
            this.setStatus();
        }
    }

    void lastPage() {
        this.m_Navigation.last();
        this.m_Goto.setText(String.valueOf(this.m_Navigation.getPageNo()));
        this.setStatus();
    }

    void gotoPage() {
        try {
            int n = Integer.valueOf(this.m_Goto.getText());
            if (this.m_Navigation.gotoPage(n)) {
                this.m_Goto.setText(String.valueOf(this.m_Navigation.getPageNo()));
                this.setStatus();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.m_Goto.setText(String.valueOf(this.m_Navigation.getPageNo()));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == FIRST_PAGE) {
            this.firstPage();
        } else if (string == PREVIOUS_PAGE) {
            this.previousPage();
        } else if (string == NEXT_PAGE) {
            this.nextPage();
        } else if (string == LAST_PAGE) {
            this.lastPage();
        } else {
            this.gotoPage();
        }
    }

    private void loadResources() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.m_Bundle = ResourceBundle.getBundle(BASE, Locale.getDefault(), classLoader);
    }

    private void buildView(int n) {
        FlowLayout flowLayout = new FlowLayout(n);
        flowLayout.setHgap(1);
        this.setLayout(flowLayout);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.m_First = this.newImageButton(FIRST_PAGE);
        this.m_Previous = this.newImageButton(PREVIOUS_PAGE);
        this.m_Next = this.newImageButton(NEXT_PAGE);
        this.m_Last = this.newImageButton(LAST_PAGE);
        this.add(this.m_First);
        this.add(this.m_Previous);
        this.m_Goto = new JTextField(String.valueOf(this.m_Navigation.getPageNo()), 3);
        this.m_Goto.setToolTipText(this.getTip(GOTO_PAGE));
        this.m_Goto.addActionListener(this);
        this.add(this.m_Goto);
        this.m_TotalPage = new JLabel();
        this.m_TotalPage.setText("/ " + this.m_Navigation.getPageCount());
        this.add(this.m_TotalPage);
        this.add(this.m_Next);
        this.add(this.m_Last);
    }

    public void refresh() {
        this.m_Goto.setText(String.valueOf(this.m_Navigation.getPageNo()));
        this.m_TotalPage.setText("/ " + this.m_Navigation.getPageCount());
    }

    public void setStatus() {
        int n = this.m_Navigation.getPageNo();
        int n2 = this.m_Navigation.getPageCount();
        if (n == 0 && n2 == 0) {
            this.m_First.setEnabled(false);
            this.m_Previous.setEnabled(false);
            this.m_Goto.setEnabled(false);
            this.m_Next.setEnabled(false);
            this.m_Last.setEnabled(false);
            this.m_TotalPage.setEnabled(false);
            return;
        }
        this.m_First.setEnabled(n > 1);
        this.m_Previous.setEnabled(n > 1);
        this.m_Goto.setEnabled(n2 > 1);
        this.m_Next.setEnabled(n < n2);
        this.m_Last.setEnabled(n < n2);
        this.m_TotalPage.setEnabled(true);
    }

    public JButton newImageButton(String string) {
        JButton jButton = new JButton(this.getIcon(string));
        jButton.setToolTipText(this.getTip(string));
        jButton.setActionCommand(string);
        jButton.setPreferredSize(new Dimension(20, 20));
        jButton.addActionListener(this);
        return jButton;
    }

    public String getTip(String string) {
        return this.m_Bundle.getString(string + ".Tip");
    }

    public Icon getIcon(String string) {
        String string2 = this.m_Bundle.getString(string + ".Icon");
        try {
            URL uRL = ClassLoader.getSystemResource(string2);
            if (uRL == null && (uRL = this.getClass().getResource("/" + string2)) == null) {
                return null;
            }
            return new ImageIcon(uRL);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

