/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.arch.IRenderable2;
import com.elixirtech.ui.IRenderable;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class LCellRenderer
extends JLabel
implements ListCellRenderer<Object> {
    private Border m_FocusBorder;
    private Border m_NoFocusBorder;

    public LCellRenderer() {
        this.setOpaque(true);
        this.loadUI();
        if (this.m_NoFocusBorder == null) {
            this.m_NoFocusBorder = new EmptyBorder(1, 1, 1, 1);
        }
        this.setBorder(this.m_NoFocusBorder);
    }

    protected void loadUI() {
        this.m_NoFocusBorder = UIManager.getBorder("List.cellNoFocusBorder");
        this.m_FocusBorder = UIManager.getBorder("List.focusCellHighlightBorder");
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.setComponentOrientation(jList.getComponentOrientation());
        JLabel jLabel = this;
        if (object instanceof JLabel) {
            jLabel = (JLabel)object;
        }
        jLabel.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
        jLabel.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
        jLabel.setFont(jList.getFont());
        jLabel.setEnabled(jList.isEnabled());
        jLabel.setBorder(bl2 ? this.m_FocusBorder : this.m_NoFocusBorder);
        if (object instanceof JLabel) {
            return jLabel;
        }
        if (object instanceof IRenderable) {
            IRenderable iRenderable = (IRenderable)object;
            jLabel.setText(iRenderable.getName());
            Icon icon = iRenderable.getIcon();
            jLabel.setIcon(icon);
        } else if (object instanceof IRenderable2) {
            IRenderable2 iRenderable2 = (IRenderable2)object;
            jLabel.setText(iRenderable2.getRenderableName());
            Icon icon = iRenderable2.getRenderableIcon();
            jLabel.setIcon(icon);
        } else {
            jLabel.setText(object != null ? object.toString() : "");
            jLabel.setIcon(null);
        }
        return jLabel;
    }
}

