/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.ui.SwingFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class MultiColumnList
extends JPanel {
    int m_ColumnCount;
    ListModel m_ListModel;
    TModel m_TableModel;
    private JTable m_Table;

    public MultiColumnList() {
        this.setLayout(new BorderLayout());
        this.setColumnCount(2);
        this.configureTable();
    }

    public MultiColumnList(int n) {
        this.setLayout(new BorderLayout());
        this.setColumnCount(n);
        this.configureTable();
    }

    public void setColumnCount(int n) {
        this.m_ColumnCount = n;
        if (this.m_TableModel != null) {
            this.m_TableModel.fireTableStructureChanged();
        }
    }

    public void setRowHeight(int n) {
        this.m_Table.setRowHeight(n);
    }

    public int getColumnCount() {
        return this.m_ColumnCount;
    }

    public void setModel(ListModel listModel) {
        this.m_ListModel = listModel;
    }

    public int getSelectedIndex() {
        int n = this.m_Table.getSelectedColumn();
        if (n == -1) {
            return -1;
        }
        int n2 = this.m_Table.getSelectedRow();
        if (n2 == -1) {
            return -1;
        }
        int n3 = n * this.m_TableModel.getRowCount() + n2;
        if (n3 >= this.m_ListModel.getSize()) {
            n3 = -1;
        }
        return n3;
    }

    public void setSelection(Object object) {
        int n = this.m_ListModel.getSize();
        for (int i = 0; i < n; ++i) {
            if (!object.equals(this.m_ListModel.getElementAt(i))) continue;
            int n2 = this.m_TableModel.getRowCount();
            int n3 = i / n2;
            int n4 = i % n2;
            this.m_Table.changeSelection(n4, n3, false, false);
            break;
        }
    }

    public Object getSelectedValue() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return this.m_ListModel.getElementAt(n);
    }

    public void setCellRenderer(ListCellRenderer listCellRenderer) {
        this.m_Table.setDefaultRenderer(Object.class, new TCR(listCellRenderer));
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.m_Table.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    private void configureTable() {
        this.m_Table = SwingFactory.newTable();
        this.m_Table.setCellSelectionEnabled(true);
        this.m_Table.setSelectionMode(0);
        this.m_Table.setShowGrid(false);
        this.m_TableModel = new TModel();
        this.m_Table.setModel(this.m_TableModel);
        this.add((Component)this.m_Table, "Center");
    }

    private class TModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private TModel() {
        }

        @Override
        public int getColumnCount() {
            return MultiColumnList.this.m_ColumnCount;
        }

        @Override
        public int getRowCount() {
            int n = MultiColumnList.this.m_ListModel.getSize();
            return n / 2 + n % 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            int n3 = n2 * this.getRowCount() + n;
            if (n3 >= MultiColumnList.this.m_ListModel.getSize()) {
                return null;
            }
            return MultiColumnList.this.m_ListModel.getElementAt(n3);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return Object.class;
        }
    }

    private class TCR
    implements TableCellRenderer {
        private ListCellRenderer m_LCR;

        public TCR(ListCellRenderer listCellRenderer) {
            this.m_LCR = listCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            int n3 = n2 * MultiColumnList.this.m_ColumnCount + n;
            return this.m_LCR.getListCellRendererComponent(null, object, n3, bl, bl2);
        }
    }
}

