/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.i18n.Bundle;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.ui.EditableTable;
import javax.swing.JButton;
import javax.swing.table.TableModel;

public class OrderedEditableTable
extends EditableTable {
    public static final String UP = "up";
    public static final String DOWN = "down";
    protected boolean m_ShowOrder = true;
    protected JButton m_MoveUp;
    protected JButton m_MoveDown;
    protected boolean m_AllowOrdering = true;

    public OrderedEditableTable(TableModel tableModel) {
        super(tableModel);
    }

    public OrderedEditableTable(TableModel tableModel, boolean bl) {
        super(tableModel, bl);
    }

    public OrderedEditableTable(TableModel tableModel, boolean bl, boolean bl2) {
        super(tableModel, bl, bl2);
    }

    public OrderedEditableTable(TableModel tableModel, boolean bl, boolean bl2, boolean bl3) {
        super(tableModel, bl, bl2, bl3);
    }

    public OrderedEditableTable(TableModel tableModel, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(tableModel, bl, bl2, bl3);
        if (!bl4) {
            this.m_Items.remove(this.m_MoveUp);
            this.m_Items.remove(this.m_MoveDown);
        }
    }

    public void allowOrdering(boolean bl) {
        this.m_AllowOrdering = bl;
        this.checkEnabled();
    }

    @Override
    public void checkEnabled() {
        super.checkEnabled();
        if (this.m_Table.isEnabled()) {
            int[] nArray = this.m_Table.getSelectedRows();
            int n = this.m_Table.getRowCount() - 1;
            this.m_MoveUp.setEnabled(this.m_AllowOrdering && nArray.length == 1 && nArray[0] > 0);
            this.m_MoveDown.setEnabled(this.m_AllowOrdering && nArray.length == 1 && nArray[0] < n);
        } else {
            this.m_MoveUp.setEnabled(false);
            this.m_MoveDown.setEnabled(false);
        }
    }

    @Override
    protected void initButtons() {
        super.initButtons();
        this.m_MoveUp = this.button(UP, Bundle.ARCH.getString("MoveUp"), StandardIcons.UP);
        this.m_MoveDown = this.button(DOWN, Bundle.ARCH.getString("MoveDown"), StandardIcons.DOWN);
        this.m_Items.add(this.m_MoveUp);
        this.m_Items.add(this.m_MoveDown);
        this.m_MoveUp.setMnemonic('U');
        this.m_MoveDown.setMnemonic('J');
    }
}

