/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.CodeBlock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class PopupDialogTemplate
extends JDialog {
    private String m_SelectedValue = "";
    private static final long serialVersionUID = -7577912261928085390L;
    protected JPanel m_ContentPanel;
    private JButton m_OkButton;

    public PopupDialogTemplate(Component component, String string) {
        this.setLocationRelativeTo(component);
        this.setTitle(string);
        this.setDefaultCloseOperation(2);
        this.m_ContentPanel = new JPanel();
        String string2 = "content-pane";
        this.m_ContentPanel.setName(string2);
        this.m_ContentPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        ArchLayout archLayout = new ArchLayout();
        this.m_ContentPanel.setLayout(archLayout);
        this.fillContentPanel();
        JPanel jPanel = new JPanel();
        String string3 = "south-pane";
        jPanel.setName(string3);
        this.m_OkButton = SwingFactory.newOkButton(new CodeBlock((Object)this, "ok"));
        this.m_OkButton.setText(Bundle.ARCH_MAP.getString("SwingFactory.Ok.text"));
        JButton jButton = SwingFactory.newCancelButton(new CodeBlock((Object)this, "cancel"));
        jButton.setText(Bundle.ARCH_MAP.getString("SwingFactory.Cancel.text"));
        jPanel.add(this.m_OkButton);
        jPanel.add(jButton);
        this.setLayout(new BorderLayout());
        Container container = this.getContentPane();
        container.add((Component)this.m_ContentPanel, "Center");
        container.add((Component)jPanel, "South");
    }

    protected abstract void fillContentPanel();

    public void setSelectedValue(String string) {
        this.m_SelectedValue = string;
        if (!this.validateSelectedValue()) {
            this.m_OkButton.setEnabled(false);
        } else {
            this.m_OkButton.setEnabled(true);
        }
    }

    public boolean validateSelectedValue() {
        return true;
    }

    public void showDialog() {
        this.pack();
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.showModal(this);
    }

    public String getSelectedValue() {
        return this.m_SelectedValue;
    }

    public void ok() {
        this.dispose();
    }

    public void cancel() {
        this.m_SelectedValue = null;
        this.dispose();
    }
}

