/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.ui.IPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class ProductBar
extends JComponent
implements ActionListener {
    private JComponent m_Above = Box.createVerticalBox();
    private JComponent m_Center = Box.createVerticalBox();
    private JComponent m_Below = Box.createVerticalBox();
    private List<Section> m_Sections = new ArrayList<Section>();
    private Section m_SelectedSection;
    private Item m_SelectedItem;
    private int m_MaxWidth;
    static final Border SELECTED = BorderFactory.createLineBorder(Color.blue);
    static final Border EMPTY = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    static final Color SELECTED_COLOR = SystemColor.control;
    static final Color EMPTY_COLOR = SystemColor.controlShadow;
    static final Font SELECTED_FONT = new Font("SansSerif", 1, 12);
    static final Font EMPTY_FONT = new Font("SansSerif", 0, 12);

    public ProductBar() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.add((Component)this.m_Above, "North");
        this.add((Component)new JScrollPane(this.m_Center), "Center");
        this.add((Component)this.m_Below, "South");
    }

    public void addSection(Section section) {
        this.m_Sections.add(section);
        if (this.m_Sections.size() == 1) {
            this.m_Above.add(section);
            this.m_SelectedSection = section;
            this.m_SelectedSection.setSelected(true);
            this.expand(section);
        } else {
            this.m_Below.add(section);
        }
        this.validate();
    }

    public void select(Section section) {
        if (this.m_SelectedSection != section) {
            int n;
            if (this.m_SelectedSection != null) {
                this.m_SelectedSection.setSelected(false);
            }
            this.m_SelectedSection = section;
            this.m_SelectedSection.setSelected(true);
            int n2 = this.m_Sections.indexOf(this.m_SelectedSection);
            this.m_Above.removeAll();
            this.m_Below.removeAll();
            int n3 = this.m_Sections.size();
            for (n = 0; n <= n2; ++n) {
                this.m_Above.add(this.m_Sections.get(n));
            }
            for (n = n2 + 1; n < n3; ++n) {
                this.m_Below.add(this.m_Sections.get(n));
            }
            this.expand(section);
            this.validate();
        }
    }

    public void expand(Section section) {
        Item item;
        Component[] componentArray = this.m_Center.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            item = (Item)((JPanel)componentArray[i]).getComponents()[0];
            item.removeActionListener(this);
        }
        this.m_Center.removeAll();
        Iterator iterator = section.getItems();
        while (iterator.hasNext()) {
            item = (Item)iterator.next();
            item.addActionListener(this);
            this.m_Center.add(this.panel(item));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width < this.m_MaxWidth) {
            dimension.width = this.m_MaxWidth;
        } else {
            this.m_MaxWidth = dimension.width;
        }
        return dimension;
    }

    public JComponent button(String string) {
        return this.panel(new JButton(string));
    }

    public JComponent panel(JComponent jComponent) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(jComponent);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_SelectedItem != null) {
            this.m_SelectedItem.setSelected(false);
        }
        this.m_SelectedItem = (Item)actionEvent.getSource();
        this.m_SelectedItem.setSelected(true);
    }

    public class Section
    extends JPanel
    implements ActionListener {
        private JButton m_Button;
        private List<Item> m_Items;

        Section(String string) {
            super(new BorderLayout());
            this.m_Items = new ArrayList<Item>();
            this.m_Button = new JButton(string);
            this.m_Button.setFocusPainted(false);
            this.m_Button.setFont(EMPTY_FONT);
            this.m_Button.setMargin(new Insets(2, 2, 2, 2));
            this.m_Button.addActionListener(this);
            this.add(this.m_Button);
        }

        public void setSelected(boolean bl) {
            if (bl) {
                this.m_Button.setFont(SELECTED_FONT);
            } else {
                this.m_Button.setFont(EMPTY_FONT);
            }
            this.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProductBar.this.select(this);
        }

        public void addItem(Item item) {
            this.m_Items.add(item);
        }

        public Iterator getItems() {
            return this.m_Items.iterator();
        }
    }

    public static class Item
    extends JButton {
        private IPanel m_Panel;

        public Item(Icon icon, IPanel iPanel) {
            super(null, icon);
            this.m_Panel = iPanel;
            this.setFocusPainted(false);
            this.setBorder(EMPTY);
            this.setBackground(EMPTY_COLOR);
            this.setMargin(new Insets(10, 10, 10, 10));
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
        }

        public IPanel getPanel() {
            return this.m_Panel;
        }

        @Override
        public void setSelected(boolean bl) {
            if (bl) {
                this.setBorder(SELECTED);
                this.setBackground(SELECTED_COLOR);
                this.setEnabled(false);
            } else {
                this.setBorder(EMPTY);
                this.setBackground(EMPTY_COLOR);
                this.setEnabled(true);
            }
            this.repaint();
        }
    }
}

