/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.ui.SwingFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RegExpField
extends JPanel
implements DocumentListener {
    private JTextField m_Text;
    private JButton m_Button;
    private boolean m_Ok;
    private String m_Error;
    private List<Listener> m_Listeners = new ArrayList<Listener>();

    public RegExpField(String string) {
        this.setName(string);
        this.m_Text = SwingFactory.newTextField(string + "-field");
        this.m_Text.getDocument().addDocumentListener(this);
        this.m_Button = SwingFactory.newDotsButton();
        this.validatePattern();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_Text, "Center");
        this.add((Component)this.m_Button, "East");
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_Text.setEnabled(bl);
        this.m_Button.setEnabled(bl);
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_Button.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_Button.removeActionListener(actionListener);
    }

    public String getText() {
        return this.m_Text.getText();
    }

    public void setText(String string) {
        this.m_Text.setText(string);
    }

    public void addListener(Listener listener) {
        this.m_Listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.m_Listeners.remove(listener);
    }

    public boolean isOk() {
        return this.m_Ok;
    }

    public String getError() {
        return this.m_Error;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.validatePattern();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.validatePattern();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.validatePattern();
    }

    protected void validatePattern() {
        this.m_Error = null;
        String string = this.m_Text.getText();
        try {
            Pattern.compile(string);
            this.m_Ok = true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.m_Ok = false;
            this.m_Error = patternSyntaxException.getMessage().split("\n")[0];
        }
        Iterator<Listener> iterator = this.m_Listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().patternChanged(this);
        }
    }

    public static interface Listener {
        public void patternChanged(RegExpField var1);
    }
}

