/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ShadowBorder
implements Border {
    private Insets m_Insets;
    public static final Insets INSETS = new Insets(4, 4, 6, 6);

    public ShadowBorder() {
        this.m_Insets = new Insets(ShadowBorder.INSETS.top, ShadowBorder.INSETS.left, ShadowBorder.INSETS.right, ShadowBorder.INSETS.bottom);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public void tightLeft() {
        this.m_Insets.left = 1;
    }

    public void tightTop() {
        this.m_Insets.top = 1;
    }

    public void tightRight() {
        this.m_Insets.right = 3;
    }

    public void tightBottom() {
        this.m_Insets.bottom = 3;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(UIManager.getColor("Panel.background"));
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(SystemColor.controlDkShadow);
        int n5 = n + this.m_Insets.left - 1;
        int n6 = n2 + this.m_Insets.top - 1;
        int n7 = n + n3 - this.m_Insets.right;
        int n8 = n2 + n4 - this.m_Insets.bottom;
        graphics.drawLine(n5, n6, n7, n6);
        graphics.drawLine(n7, n6, n7, n8);
        graphics.drawLine(n7, n8, n5, n8);
        graphics.drawLine(n5, n8, n5, n6);
        graphics.drawLine(n7 + 1, n6 + 1, n7 + 1, n8 + 1);
        graphics.drawLine(n5 + 1, n8 + 1, n7 + 1, n8 + 1);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n7 + 2, n6 + 2, n7 + 2, n8 + 1);
        graphics.drawLine(n5 + 2, n8 + 2, n7 + 1, n8 + 2);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.m_Insets;
    }
}

