/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.arch.ElxLoggerJ;
import java.awt.Color;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;

public final class StandardColor
extends Color {
    private static final Pattern RGB_PATTERN = Pattern.compile("\\s*(rgb)?\\s*\\(\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*,\\s*([0-9]+)\\s*(,\\s*([0-9]+))?\\s*\\)");
    private final String m_Name;
    private static Map<String, Color> m_ColorMap = new ConcurrentHashMap<String, Color>();
    private static Map<Color, String> m_NameMap = new ConcurrentHashMap<Color, String>();
    private static Map<String, Color> m_LowerCaseColorMap = new ConcurrentHashMap<String, Color>();
    public static final StandardColor ALICE_BLUE = new StandardColor("AliceBlue", 240, 248, 255);
    public static final StandardColor ANTIQUE_WHITE = new StandardColor("AntiqueWhite", 250, 235, 215);
    public static final StandardColor AQUA = new StandardColor("Aqua", 0, 255, 255);
    public static final StandardColor AQUAMARINE = new StandardColor("Aquamarine", 127, 255, 212);
    public static final StandardColor AZURE = new StandardColor("Azure", 240, 255, 255);
    public static final StandardColor BEIGE = new StandardColor("Beige", 245, 245, 220);
    public static final StandardColor BISQUE = new StandardColor("Bisque", 255, 228, 196);
    public static final StandardColor STD_BLACK = new StandardColor("Black", 0, 0, 0);
    public static final StandardColor BLANCHED_ALMOND = new StandardColor("BlanchedAlmond", 255, 235, 205);
    public static final StandardColor STD_BLUE = new StandardColor("Blue", 0, 0, 255);
    public static final StandardColor BLUE_VIOLET = new StandardColor("BlueViolet", 138, 43, 226);
    public static final StandardColor BROWN = new StandardColor("Brown", 165, 42, 42);
    public static final StandardColor BURLY_WOOD = new StandardColor("BurlyWood", 222, 184, 135);
    public static final StandardColor CADET_BLUE = new StandardColor("Cadet_Blue", 95, 158, 160);
    public static final StandardColor CHARTREUSE = new StandardColor("Chartreuse", 127, 255, 0);
    public static final StandardColor CHOCOLATE = new StandardColor("Chocolate", 210, 105, 30);
    public static final StandardColor CORAL = new StandardColor("Coral", 255, 127, 80);
    public static final StandardColor CORNFLOWERBLUE = new StandardColor("CornflowerBlue", 100, 149, 237);
    public static final StandardColor CORNSILK = new StandardColor("CornSilk", 255, 248, 220);
    public static final StandardColor CRIMSON = new StandardColor("Crimson", 220, 20, 60);
    public static final StandardColor STD_CYAN = new StandardColor("Cyan", 0, 255, 255);
    public static final StandardColor DARK_BLUE = new StandardColor("DarkBlue", 0, 0, 139);
    public static final StandardColor DARK_CYAN = new StandardColor("DarkCyan", 0, 139, 139);
    public static final StandardColor DARK_GOLDENROD = new StandardColor("DarkGoldenrod", 184, 134, 11);
    public static final StandardColor STD_DARK_GRAY = new StandardColor("DarkGray", 169, 169, 169);
    public static final StandardColor DARK_GREEN = new StandardColor("DarkGreen", 0, 100, 0);
    public static final StandardColor DARK_GREY = new StandardColor("DarkGrey", 169, 169, 169);
    public static final StandardColor DARK_KHAKI = new StandardColor("DarkKhaki", 189, 183, 107);
    public static final StandardColor DARK_MAGENTA = new StandardColor("DarkMagenta", 139, 0, 139);
    public static final StandardColor DARK_OLIVE_GREEN = new StandardColor("DarkOliveGreen", 85, 107, 47);
    public static final StandardColor DARK_ORANGE = new StandardColor("DarkOrange", 255, 140, 0);
    public static final StandardColor DARK_ORCHID = new StandardColor("DarkOrchid", 153, 50, 204);
    public static final StandardColor DARK_RED = new StandardColor("DarkRed", 139, 0, 0);
    public static final StandardColor DARK_SALMON = new StandardColor("DarkSalmon", 233, 150, 122);
    public static final StandardColor DARK_SEA_GREEN = new StandardColor("DarkSeaGreen", 143, 188, 143);
    public static final StandardColor DARK_SLATE_BLUE = new StandardColor("DarkSlateBlue", 72, 61, 139);
    public static final StandardColor DARK_SLATE_GRAY = new StandardColor("DarkSlateGray", 47, 79, 79);
    public static final StandardColor DARK_SLATE_GREY = new StandardColor("DarkSlateGrey", 47, 79, 79);
    public static final StandardColor DARK_TURQUOISE = new StandardColor("DarkTurquoise", 0, 206, 209);
    public static final StandardColor DARK_VIOLET = new StandardColor("DarkViolet", 148, 0, 211);
    public static final StandardColor DEEP_PINK = new StandardColor("DeepPink", 255, 20, 147);
    public static final StandardColor DEEP_SKY_BLUE = new StandardColor("DeepSkyBlue", 0, 191, 255);
    public static final StandardColor DIM_GRAY = new StandardColor("DimGray", 105, 105, 105);
    public static final StandardColor DIM_GREY = new StandardColor("DimGrey", 105, 105, 105);
    public static final StandardColor DODGER_BLUE = new StandardColor("DodgerBlue", 30, 144, 255);
    public static final StandardColor FIRE_BRICK = new StandardColor("FireBrick", 178, 34, 34);
    public static final StandardColor FLORAL_WHITE = new StandardColor("FloralWhite", 255, 250, 240);
    public static final StandardColor FOREST_GREEN = new StandardColor("ForestGreen", 34, 139, 34);
    public static final StandardColor FUCHSIA = new StandardColor("Fuchsia", 255, 0, 255);
    public static final StandardColor GAINSBORO = new StandardColor("Gainsboro", 220, 200, 200);
    public static final StandardColor GHOST_WHITE = new StandardColor("GhostWhite", 248, 248, 255);
    public static final StandardColor GOLD = new StandardColor("Gold", 255, 215, 0);
    public static final StandardColor GOLDENROD = new StandardColor("Goldenrod", 218, 165, 32);
    public static final StandardColor STD_GRAY = new StandardColor("Gray", 128, 128, 128);
    public static final StandardColor GREY = new StandardColor("Grey", 128, 128, 128);
    public static final StandardColor STD_GREEN = new StandardColor("Green", 0, 128, 0);
    public static final StandardColor JAVAGREEN = new StandardColor("JavaGreen", 0, 255, 0);
    public static final StandardColor GREENYELLOW = new StandardColor("GreenYellow", 173, 255, 47);
    public static final StandardColor HONEYDEW = new StandardColor("HoneyDew", 240, 255, 240);
    public static final StandardColor HOT_PINK = new StandardColor("HotPink", 255, 105, 180);
    public static final StandardColor INDIAN_RED = new StandardColor("IndianRed", 205, 92, 92);
    public static final StandardColor INDIGO = new StandardColor("Indigo", 75, 0, 130);
    public static final StandardColor IVORY = new StandardColor("Ivory", 255, 255, 240);
    public static final StandardColor KHAKI = new StandardColor("Khaki", 240, 230, 140);
    public static final StandardColor LAVENDER = new StandardColor("Lavender", 230, 230, 250);
    public static final StandardColor LAVENDER_BLUSH = new StandardColor("LavenderBlush", 255, 240, 255);
    public static final StandardColor LAWN_GREEN = new StandardColor("LawnGreen", 124, 252, 0);
    public static final StandardColor LEMON_CHIFFON = new StandardColor("LemonChiffron", 255, 250, 205);
    public static final StandardColor LIGHT_BLUE = new StandardColor("LightBlue", 173, 216, 230);
    public static final StandardColor LIGHT_CORAL = new StandardColor("LightCoral", 240, 128, 128);
    public static final StandardColor LIGHT_CYAN = new StandardColor("LightCyan", 224, 255, 255);
    public static final StandardColor LIGHT_GOLDENROD_YELLOW = new StandardColor("LightGoldenrodYellow", 250, 250, 210);
    public static final StandardColor STD_LIGHT_GRAY = new StandardColor("LightGray", 211, 211, 211);
    public static final StandardColor LIGHT_GREEN = new StandardColor("LightGreen", 144, 238, 144);
    public static final StandardColor LIGHT_GREY = new StandardColor("LightGrey", 211, 211, 211);
    public static final StandardColor LIGHT_PINK = new StandardColor("LightPink", 255, 182, 193);
    public static final StandardColor LIGHT_SALMON = new StandardColor("LightSalmon", 255, 160, 122);
    public static final StandardColor LIGHT_SEA_GREEN = new StandardColor("LightSeaGreen", 32, 178, 170);
    public static final StandardColor LIGHT_SKY_BLUE = new StandardColor("LightSkyBlue", 135, 206, 250);
    public static final StandardColor LIGHT_SLATE_GRAY = new StandardColor("LightSlateGray", 119, 136, 153);
    public static final StandardColor LIGHT_SLATE_GREY = new StandardColor("LightSlateGray", 119, 136, 153);
    public static final StandardColor LIGHT_STEEL_BLUE = new StandardColor("LightSteelBlue", 176, 196, 222);
    public static final StandardColor LIGHT_YELLOW = new StandardColor("LightYellow", 255, 255, 224);
    public static final StandardColor LIME_GREEN = new StandardColor("LimeGreen", 50, 205, 50);
    public static final StandardColor LINEN = new StandardColor("Linen", 250, 240, 230);
    public static final StandardColor STD_MAGENTA = new StandardColor("Magenta", 255, 0, 255);
    public static final StandardColor MAROON = new StandardColor("Maroon", 128, 0, 0);
    public static final StandardColor MEDIUM_AQUAMARINE = new StandardColor("MediumAquamarine", 102, 205, 170);
    public static final StandardColor MEDIUM_BLUE = new StandardColor("MediumBlue", 0, 0, 205);
    public static final StandardColor MEDIUM_ORCHID = new StandardColor("MediumOrchard", 186, 85, 211);
    public static final StandardColor MEDIUM_PURPLE = new StandardColor("MediumPurple", 147, 112, 219);
    public static final StandardColor MEDIUM_SEA_GREEN = new StandardColor("MediumSeaGreen", 60, 179, 113);
    public static final StandardColor MEDIUM_SLATE_BLUE = new StandardColor("MediumSlateBlue", 123, 104, 238);
    public static final StandardColor MEDIUM_SPRING_GREEN = new StandardColor("MediumSpringGreen", 0, 250, 154);
    public static final StandardColor MEDIUM_TURQUOISE = new StandardColor("MediumTurquoise", 72, 209, 204);
    public static final StandardColor MEDIUM_VIOLET_RED = new StandardColor("MediumVioletRed", 199, 21, 133);
    public static final StandardColor MIDNIGHT_BLUE = new StandardColor("MidnightBlue", 25, 25, 112);
    public static final StandardColor MINT_CREAM = new StandardColor("MintCream", 245, 255, 250);
    public static final StandardColor MISTY_ROSE = new StandardColor("MistyRose", 255, 228, 225);
    public static final StandardColor MOCCASIN = new StandardColor("Moccasin", 255, 228, 181);
    public static final StandardColor NAVAJO_WHITE = new StandardColor("NavajoWhite", 255, 222, 173);
    public static final StandardColor NAVY = new StandardColor("Navy", 0, 0, 128);
    public static final StandardColor OLD_LACE = new StandardColor("OldLace", 253, 245, 230);
    public static final StandardColor OLIVE = new StandardColor("Olive", 128, 128, 0);
    public static final StandardColor OLIVE_DRAB = new StandardColor("OliveDrab", 107, 142, 35);
    public static final StandardColor STD_ORANGE = new StandardColor("Orange", 255, 165, 0);
    public static final StandardColor ORANGE_RED = new StandardColor("OrangeRed", 255, 69, 0);
    public static final StandardColor ORCHID = new StandardColor("Orchid", 218, 112, 214);
    public static final StandardColor PALE_GOLDENROD = new StandardColor("PaleGoldenRod", 238, 232, 170);
    public static final StandardColor PALE_GREEN = new StandardColor("PaleGreen", 152, 251, 152);
    public static final StandardColor PALE_TURQUOISE = new StandardColor("PaleTurquoise", 175, 238, 238);
    public static final StandardColor PALE_VIOLET_RED = new StandardColor("PaleVioletRed", 219, 112, 147);
    public static final StandardColor PAPAYA_WHIP = new StandardColor("PapayaWhip", 255, 239, 213);
    public static final StandardColor PEACH_PUFF = new StandardColor("PeachPuff", 255, 218, 185);
    public static final StandardColor PERU = new StandardColor("Peru", 205, 133, 63);
    public static final StandardColor STD_PINK = new StandardColor("Pink", 255, 192, 203);
    public static final StandardColor PLUM = new StandardColor("Plum", 221, 160, 221);
    public static final StandardColor POWDER_BLUE = new StandardColor("PowderBlue", 176, 224, 230);
    public static final StandardColor PURPLE = new StandardColor("Purple", 128, 0, 128);
    public static final StandardColor STD_RED = new StandardColor("Red", 255, 0, 0);
    public static final StandardColor ROSY_BROWN = new StandardColor("RosyBrown", 188, 143, 143);
    public static final StandardColor ROYAL_BLUE = new StandardColor("RoyalBlue", 65, 105, 225);
    public static final StandardColor SADDLE_BROWN = new StandardColor("SaddleBrown", 139, 69, 19);
    public static final StandardColor SALMON = new StandardColor("Salmon", 250, 69, 114);
    public static final StandardColor SANDY_BROWN = new StandardColor("SandyBrown", 244, 164, 96);
    public static final StandardColor SEA_GREEN = new StandardColor("SeaGreen", 46, 139, 87);
    public static final StandardColor SEASHELL = new StandardColor("Seashell", 255, 245, 238);
    public static final StandardColor SIENNA = new StandardColor("Sienna", 160, 82, 45);
    public static final StandardColor SILVER = new StandardColor("Silver", 192, 192, 192);
    public static final StandardColor SKY_BLUE = new StandardColor("SkyBlue", 135, 206, 235);
    public static final StandardColor SLATE_BLUE = new StandardColor("SlateBlue", 106, 90, 205);
    public static final StandardColor SLATE_GRAY = new StandardColor("SlateGray", 112, 128, 144);
    public static final StandardColor SLATE_GREY = new StandardColor("SlateGrey", 112, 128, 144);
    public static final StandardColor SNOW = new StandardColor("Snow", 255, 250, 250);
    public static final StandardColor SPRING_GREEN = new StandardColor("SpringGreen", 0, 255, 127);
    public static final StandardColor STEEL_BLUE = new StandardColor("SteelBlue", 70, 130, 180);
    public static final StandardColor TAN = new StandardColor("Tan", 210, 180, 140);
    public static final StandardColor TEAL = new StandardColor("Teal", 0, 128, 128);
    public static final StandardColor THISTLE = new StandardColor("Thistle", 216, 91, 216);
    public static final StandardColor TOMATO = new StandardColor("Tomato", 255, 99, 71);
    public static final StandardColor TURQUOISE = new StandardColor("Turquoise", 64, 224, 208);
    public static final StandardColor VIOLET = new StandardColor("Violet", 238, 130, 238);
    public static final StandardColor WHEAT = new StandardColor("Wheat", 245, 222, 179);
    public static final StandardColor STD_WHITE = new StandardColor("White", 255, 255, 255);
    public static final StandardColor WHITE_SMOKE = new StandardColor("WhiteSmoke", 245, 245, 245);
    public static final StandardColor STD_YELLOW = new StandardColor("Yellow", 255, 255, 0);
    public static final StandardColor YELLOW_GREEN = new StandardColor("YellowGreen", 154, 205, 50);
    public static final StandardColor TRANSPARENT = new StandardColor("Transparent", 0, 0, 0, 0);
    public static final StandardColor NONE = new StandardColor("None", 0, 0, 0, 0);
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(StandardColor.class);

    public static void main(String[] stringArray) {
        System.out.println(StandardColor.lookup("rgb(255,255,255)"));
        System.out.println(StandardColor.lookup("rgb(132,123,143)"));
        System.out.println(StandardColor.lookup("rgb(132,123,143,0)"));
        System.out.println(StandardColor.lookup("Transparent"));
        System.out.println(StandardColor.lookup("  rgb ( 132 , 123 , 143 ) "));
        System.out.println(StandardColor.lookup("  rgb ( 132 , 123 , 143, 255 ) "));
        System.out.println(StandardColor.lookup("ui(Table.selectionBackground)"));
    }

    public static Color lookup(String string) {
        return StandardColor.lookup(string, NONE);
    }

    public static Color lookup(String string, String string2) {
        return StandardColor.lookup(string, StandardColor.lookup(string2, NONE));
    }

    public static Color lookup(String string, Color color) {
        if (string == null) {
            return color;
        }
        String string2 = string.trim();
        if (string2.length() == 0) {
            return color;
        }
        try {
            Color color2 = m_ColorMap.get(string2);
            if (color2 == null) {
                if (string2.startsWith("rgb")) {
                    color2 = StandardColor.parseRGB(string2);
                } else if (string2.startsWith("ui")) {
                    color2 = StandardColor.parseUI(string2);
                } else {
                    char c = string2.charAt(0);
                    if (c == '-' || Character.isDigit(c)) {
                        try {
                            int n = Integer.parseInt(string2);
                            color2 = new Color(n);
                            m_ColorMap.put(string2, color2);
                            if (!m_NameMap.containsKey(color2)) {
                                m_NameMap.put(color2, string2);
                            }
                        }
                        catch (Exception exception) {
                            m_Log.warn((Object)("Bad color name: '" + string2 + "'"));
                            color2 = color;
                        }
                    } else {
                        int n;
                        Object object = string2.trim();
                        while ((n = ((String)object).indexOf(" ")) >= 0) {
                            object = ((String)object).substring(0, n) + ((String)object).substring(n + 1);
                        }
                        color2 = m_LowerCaseColorMap.get(((String)object).toLowerCase(Locale.ENGLISH));
                    }
                }
            }
            if (color2 == null) {
                color2 = color;
            }
            return color2;
        }
        catch (Exception exception) {
            m_Log.warn((Object)("Color " + string2 + " not found"));
            return color;
        }
    }

    public static String getColorName(Color color) {
        if (color == null) {
            return null;
        }
        String string = m_NameMap.get(color);
        if (string == null) {
            if (color.getAlpha() == 255) {
                return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
            }
            return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha() + ")";
        }
        return string;
    }

    public static void registerUserColor(String string, Color color) {
        m_ColorMap.put(string, color);
        m_LowerCaseColorMap.put(string.toLowerCase(Locale.ENGLISH), color);
    }

    private static Color parseRGB(String string) {
        Matcher matcher = RGB_PATTERN.matcher(string);
        if (matcher.lookingAt()) {
            int n = Integer.parseInt(matcher.group(2));
            int n2 = Integer.parseInt(matcher.group(3));
            int n3 = Integer.parseInt(matcher.group(4));
            int n4 = matcher.group(5) != null ? Integer.parseInt(matcher.group(6)) : 255;
            Color color = new Color(n, n2, n3, n4);
            m_ColorMap.put(string, color);
            if (!m_NameMap.containsKey(color)) {
                m_NameMap.put(color, string);
            }
            return color;
        }
        m_Log.warn((Object)("Bad RGB String: " + string));
        return STD_BLACK;
    }

    private static Color parseUI(String string) {
        String string2 = string.substring(2).trim();
        if (string2.startsWith("(")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith(")")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return UIManager.getColor(string2);
    }

    private StandardColor(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, 255);
    }

    private StandardColor(String string, int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.m_Name = string;
        m_ColorMap.put(this.m_Name, this);
        m_NameMap.put(this, this.m_Name);
        m_LowerCaseColorMap.put(this.m_Name.toLowerCase(Locale.ENGLISH), this);
    }

    public String getName() {
        return this.m_Name;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Color) {
            return ((Color)object).getRGB() == this.getRGB();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.m_Name.hashCode();
    }

    @Override
    public String toString() {
        return StandardColor.getColorName(this);
    }
}

