/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.arch.ElxLoggerJ;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.SwingUtilities;

public class SwingEventThreadProxy<T>
implements InvocationHandler {
    private T m_T;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SwingEventThreadProxy.class);

    public static <T> T newInstance(Class<T> clazz, T t) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Object object = Proxy.newProxyInstance(classLoader, new Class[]{clazz}, new SwingEventThreadProxy<T>(t));
        return clazz.cast(object);
    }

    public SwingEventThreadProxy(T t) {
        this.m_T = t;
    }

    @Override
    public Object invoke(Object object, final Method method, final Object[] objectArray) throws Throwable {
        if (method.getName().equals("equals")) {
            return object == objectArray[0];
        }
        if (method.getName().equals("hashCode")) {
            return method.invoke(this.m_T, objectArray);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return method.invoke(this.m_T, objectArray);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    method.invoke(SwingEventThreadProxy.this.m_T, objectArray);
                }
                catch (Throwable throwable) {
                    m_Log.warn((Object)("Error in proxy invoke: " + String.valueOf(throwable)));
                }
            }
        });
        return null;
    }
}

