/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.ui.ElxSplitPane;
import com.elixirtech.ui.TitledBorder;
import com.elixirtech.ui.table.ElxTable;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.SpinnerModel;

public class SwingFactory {
    public static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static String APPLY = "Apply";
    private static String CANCEL = "Cancel";
    private static String OK = "Ok";
    private static String CLOSE = "Close";

    public static JToolBar newToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setRollover(true);
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    public static JPanel newTitledPanel(LayoutManager layoutManager, JLabel jLabel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(layoutManager);
        jPanel.setBorder(new TitledBorder(jLabel));
        return jPanel;
    }

    public static JSplitPane newHorizontalSplit(Component component, Component component2) {
        return new ElxSplitPane(1, component, component2);
    }

    public static JSplitPane newVerticalSplit(Component component, Component component2) {
        return new ElxSplitPane(0, component, component2);
    }

    public static JButton newDotsButton() {
        JButton jButton = new JButton(StandardIcons.DOTS);
        jButton.setName("...");
        jButton.setMargin(EMPTY_INSETS);
        return jButton;
    }

    public static JButton newDotsButton(ActionListener actionListener) {
        JButton jButton = SwingFactory.newDotsButton();
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static JButton newDotsButton(String string, ActionListener actionListener) {
        JButton jButton = SwingFactory.newDotsButton();
        jButton.setName(string);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static JButton newOkButton() {
        JButton jButton = new JButton(OK);
        jButton.setName("SwingFactory.Ok");
        return jButton;
    }

    public static JButton newOkButton(ActionListener actionListener) {
        JButton jButton = SwingFactory.newOkButton();
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static JButton newCancelButton() {
        JButton jButton = new JButton(CANCEL);
        jButton.setName("SwingFactory.Cancel");
        return jButton;
    }

    public static JButton newCancelButton(ActionListener actionListener) {
        JButton jButton = SwingFactory.newCancelButton();
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static JButton newApplyButton() {
        JButton jButton = new JButton(APPLY);
        jButton.setName("SwingFactory.Apply");
        return jButton;
    }

    public static JButton newApplyButton(ActionListener actionListener) {
        JButton jButton = SwingFactory.newApplyButton();
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static JButton newCloseButton() {
        JButton jButton = new JButton(CLOSE);
        jButton.setName("SwingFactory.Close");
        return jButton;
    }

    public static JButton newCloseButton(ActionListener actionListener) {
        JButton jButton = SwingFactory.newCloseButton();
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static JLabel newLabel(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setName(string);
        return jLabel;
    }

    public static JButton newButton(String string) {
        JButton jButton = new JButton();
        jButton.setName(string);
        return jButton;
    }

    public static JButton newButton(String string, ActionListener actionListener) {
        if (actionListener instanceof Action) {
            JButton jButton = new JButton((Action)actionListener);
            jButton.setName(string);
            return jButton;
        }
        JButton jButton = new JButton();
        jButton.setName(string);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static JCheckBox newCheckBox(String string) {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setName(string);
        return jCheckBox;
    }

    public static JRadioButton newRadioButton(String string) {
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setName(string);
        return jRadioButton;
    }

    public static JList newList() {
        JList jList = new JList();
        jList.setBackground(Color.WHITE);
        return jList;
    }

    public static JList newList(Object[] objectArray) {
        JList<Object> jList = new JList<Object>(objectArray);
        jList.setBackground(Color.WHITE);
        return jList;
    }

    public static JList newList(Vector<?> vector) {
        JList jList = new JList(vector);
        jList.setBackground(Color.WHITE);
        return jList;
    }

    public static JList newList(ListModel listModel) {
        JList jList = new JList(listModel);
        jList.setBackground(Color.WHITE);
        return jList;
    }

    public static JList newList(String string) {
        JList jList = new JList();
        jList.setBackground(Color.WHITE);
        jList.setName(string);
        return jList;
    }

    public static JList newList(String string, Object[] objectArray) {
        JList<Object> jList = new JList<Object>(objectArray);
        jList.setBackground(Color.WHITE);
        jList.setName(string);
        return jList;
    }

    public static JList newList(String string, Vector<?> vector) {
        JList jList = new JList(vector);
        jList.setBackground(Color.WHITE);
        jList.setName(string);
        return jList;
    }

    public static JTabbedPane newTabbedPane(String string) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setName(string);
        return jTabbedPane;
    }

    public static JTextField newTextField(String string) {
        JTextField jTextField = new JTextField();
        jTextField.setName(string);
        return jTextField;
    }

    public static JPasswordField newPasswordField(String string) {
        JPasswordField jPasswordField = new JPasswordField();
        jPasswordField.setName(string);
        return jPasswordField;
    }

    public static JTextField newTextField(String string, int n) {
        JTextField jTextField = new JTextField(n);
        jTextField.setName(string);
        return jTextField;
    }

    public static JTextField newTextField(String string, String string2, int n) {
        JTextField jTextField = new JTextField(string2, n);
        jTextField.setName(string);
        return jTextField;
    }

    public static JTextArea newTextArea(String string) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setName(string);
        return jTextArea;
    }

    public static JTextArea newTextArea(String string, int n) {
        JTextArea jTextArea = SwingFactory.newTextArea(string);
        jTextArea.setRows(n);
        return jTextArea;
    }

    public static JTable newTable() {
        ElxTable elxTable = new ElxTable();
        return elxTable;
    }

    public static JTable newTable(String string) {
        ElxTable elxTable = new ElxTable();
        elxTable.setName(string);
        return elxTable;
    }

    public static JSpinner newSpinner(String string) {
        JSpinner jSpinner = new JSpinner();
        jSpinner.setName(string);
        return jSpinner;
    }

    public static JSpinner newSpinner(String string, SpinnerModel spinnerModel) {
        JSpinner jSpinner = new JSpinner(spinnerModel);
        jSpinner.setName(string);
        return jSpinner;
    }

    public static JComboBox newComboBox(String string) {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setName(string);
        return jComboBox;
    }

    public static JComboBox newComboBox(String string, ComboBoxModel comboBoxModel) {
        JComboBox jComboBox = new JComboBox(comboBoxModel);
        jComboBox.setName(string);
        return jComboBox;
    }

    public static JComboBox newComboBox(String string, Object[] objectArray) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setName(string);
        return jComboBox;
    }

    public static JComboBox newComboBox(String string, Vector<?> vector) {
        JComboBox jComboBox = new JComboBox(vector);
        jComboBox.setName(string);
        return jComboBox;
    }

    public static I18NComboBox newI18NComboBox(String string, Name[] nameArray) {
        I18NComboBox i18NComboBox = I18NComboBox.apply(nameArray);
        i18NComboBox.setName(string);
        return i18NComboBox;
    }

    public static JScrollPane newScrollPane(String string, JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        jScrollPane.setName(string);
        return jScrollPane;
    }

    public static JScrollPane newScrollPane(String string, JComponent jComponent, int n, int n2) {
        JScrollPane jScrollPane = new JScrollPane(jComponent, n, n2);
        jScrollPane.setName(string);
        return jScrollPane;
    }

    public static JDateChooser newDateChooser(String string) {
        JDateChooser jDateChooser = new JDateChooser();
        jDateChooser.setName(string);
        return jDateChooser;
    }

    static {
        try {
            APPLY = Bundle.ARCH.getString("SwingFactory.Apply.text");
            CANCEL = Bundle.ARCH.getString("SwingFactory.Cancel.text");
            OK = Bundle.ARCH.getString("SwingFactory.Ok.text");
            CLOSE = Bundle.ARCH.getString("SwingFactory.Close.text");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

