/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class SwingUtil {
    public static void setEnabled(Container container, boolean bl) {
        if (container.isEnabled() != bl) {
            container.setEnabled(bl);
        }
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Container) {
                SwingUtil.setEnabled((Container)componentArray[i], bl);
                continue;
            }
            componentArray[i].setEnabled(bl);
        }
    }

    public static void invokeAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread() || GraphicsEnvironment.isHeadless()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Error invoking runnable", invocationTargetException);
            }
        }
    }

    public static void setupDropTarget(Component component, DropTargetListener dropTargetListener) {
        if (!GraphicsEnvironment.isHeadless()) {
            new DropTarget(component, dropTargetListener);
        }
    }
}

