/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.ui.ItemSelectionButton;
import java.awt.Component;
import java.awt.Container;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class SwingUtils {
    public static void enableNimbus() {
        if (System.getProperty("swing.defaultlaf") == null) {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray;
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(lookAndFeelInfo.getName())) continue;
                try {
                    UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                }
                catch (Throwable throwable) {
                    System.out.println("Unable to set Nimbus look and feel: " + String.valueOf(throwable));
                }
                break;
            }
        }
    }

    public static void setComponentEnabled(Component component, boolean bl) {
        SwingUtils.setComponentEnabled(component, bl, new HashSet<Component>());
    }

    public static void setComponentEnabled(Component component, boolean bl, Set<Component> set) {
        if (SwingUtils.shouldAlwaysBeEnabled(component, set)) {
            component.setEnabled(true);
        } else {
            component.setEnabled(bl);
        }
        if (component instanceof Container) {
            Component[] componentArray;
            for (Component component2 : componentArray = ((Container)component).getComponents()) {
                SwingUtils.setComponentEnabled(component2, bl, set);
            }
        }
    }

    private static boolean shouldAlwaysBeEnabled(Component component, Set<Component> set) {
        if (component instanceof JLabel && !(component instanceof ItemSelectionButton)) {
            return true;
        }
        return set.contains(component);
    }
}

