/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.arch.IRenderable2;
import com.elixirtech.ui.IRenderable;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class TCellRenderer
extends JLabel
implements TreeCellRenderer,
TableCellRenderer {
    protected Icon m_Expanded;
    protected Icon m_Collapsed;
    protected Icon m_Leaf;
    protected Color m_TextSelectionColor;
    protected Color m_TextNonSelectionColor;

    public TCellRenderer() {
        this.setOpaque(false);
        this.loadUI();
    }

    protected void loadUI() {
        this.m_Expanded = UIManager.getIcon("Tree.openIcon");
        this.m_Collapsed = UIManager.getIcon("Tree.closedIcon");
        this.m_Leaf = UIManager.getIcon("Tree.leafIcon");
        this.m_TextSelectionColor = Color.white;
        this.m_TextNonSelectionColor = UIManager.getColor("Tree.textForeground");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof DefaultMutableTreeNode) {
            object = ((DefaultMutableTreeNode)object).getUserObject();
        }
        JLabel jLabel = this;
        if (object instanceof JLabel) {
            jLabel = (JLabel)object;
        }
        jLabel.setForeground(bl ? this.m_TextSelectionColor : this.m_TextNonSelectionColor);
        jLabel.setFont(jTree.getFont());
        if (object instanceof JLabel) {
            return jLabel;
        }
        if (object instanceof IRenderable) {
            IRenderable iRenderable = (IRenderable)object;
            jLabel.setText(iRenderable.getName());
            Icon icon = iRenderable.getIcon();
            if (icon != null) {
                jLabel.setIcon(icon);
            } else {
                this.setDefaultIcon(jLabel, bl3, bl2);
            }
        } else if (object instanceof IRenderable2) {
            IRenderable2 iRenderable2 = (IRenderable2)object;
            jLabel.setText(iRenderable2.getRenderableName());
            Icon icon = iRenderable2.getRenderableIcon();
            if (icon != null) {
                jLabel.setIcon(icon);
            } else {
                this.setDefaultIcon(jLabel, bl3, bl2);
            }
        } else {
            jLabel.setText(String.valueOf(object));
            this.setDefaultIcon(jLabel, bl3, bl2);
        }
        return jLabel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object instanceof DefaultMutableTreeNode) {
            object = ((DefaultMutableTreeNode)object).getUserObject();
        }
        JLabel jLabel = this;
        if (object instanceof JLabel) {
            jLabel = (JLabel)object;
        }
        jLabel.setForeground(bl ? this.m_TextSelectionColor : this.m_TextNonSelectionColor);
        jLabel.setFont(jTable.getFont());
        if (object instanceof JLabel) {
            return jLabel;
        }
        if (object instanceof IRenderable) {
            IRenderable iRenderable = (IRenderable)object;
            jLabel.setText(iRenderable.getName());
            jLabel.setIcon(iRenderable.getIcon());
        } else if (object instanceof IRenderable2) {
            IRenderable2 iRenderable2 = (IRenderable2)object;
            jLabel.setText(iRenderable2.getRenderableName());
            Icon icon = iRenderable2.getRenderableIcon();
            if (icon != null) {
                jLabel.setIcon(icon);
            } else {
                jLabel.setIcon(null);
            }
        } else {
            jLabel.setText(String.valueOf(object));
            jLabel.setIcon(null);
        }
        return jLabel;
    }

    private void setDefaultIcon(JLabel jLabel, boolean bl, boolean bl2) {
        Icon icon = null;
        icon = bl ? this.m_Leaf : (bl2 ? this.m_Expanded : this.m_Collapsed);
        jLabel.setIcon(icon);
    }
}

