/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableUtil {
    public static void disposeEditor(JTable jTable) {
        TableCellEditor tableCellEditor = jTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
            jTable.removeEditor();
        }
    }

    public static void setColumnWidth(JTable jTable, TableColumn tableColumn, ResourceBundle resourceBundle, String string, int n) {
        JTableHeader jTableHeader = jTable.getTableHeader();
        TableCellRenderer tableCellRenderer = jTableHeader.getDefaultRenderer();
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, resourceBundle.getString(string), false, false, 0, 0);
        int n2 = component.getPreferredSize().width + n;
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
    }

    public static void setBestColumnWidths(JTable jTable, int n) {
        TableUtil.setBestColumnWidths(jTable, n, Integer.MAX_VALUE);
    }

    public static void setBestColumnWidths(JTable jTable, int n, int n2) {
        TableModel tableModel = jTable.getModel();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        if (tableColumnModel.getColumnCount() == 0) {
            return;
        }
        TableCellRenderer tableCellRenderer = tableColumnModel.getColumn(0).getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        if (tableCellRenderer == null) {
            return;
        }
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            TableCellRenderer tableCellRenderer2 = jTable.getDefaultRenderer(tableModel.getColumnClass(i));
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumnModel.getColumn(i).getHeaderValue(), false, false, 0, 0);
            int n3 = component.getPreferredSize().width;
            for (int j = 0; j < tableModel.getRowCount(); ++j) {
                Component component2 = tableCellRenderer2.getTableCellRendererComponent(jTable, tableModel.getValueAt(j, i), false, false, j, i);
                int n4 = component2.getPreferredSize().width;
                if (n3 >= n4) continue;
                n3 = n4;
            }
            if (n3 > n2) {
                n3 = n2;
            }
            tableColumnModel.getColumn(i).setPreferredWidth(n3 + n);
        }
    }

    public static void setBestColumnWidths(JTable jTable, int n, int n2, int n3) {
        int n4;
        int n5;
        TableModel tableModel = jTable.getModel();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n6 = tableColumnModel.getColumnCount();
        if (n6 == 0) {
            return;
        }
        int[] nArray = new int[n6];
        int n7 = 0;
        TableCellRenderer tableCellRenderer = tableColumnModel.getColumn(0).getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        if (tableCellRenderer == null) {
            return;
        }
        for (n5 = 0; n5 < n6; ++n5) {
            TableCellRenderer tableCellRenderer2 = jTable.getDefaultRenderer(tableModel.getColumnClass(n5));
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumnModel.getColumn(n5).getHeaderValue(), false, false, 0, 0);
            n4 = component.getPreferredSize().width;
            for (int i = 0; i < tableModel.getRowCount(); ++i) {
                Component component2 = tableCellRenderer2.getTableCellRendererComponent(jTable, tableModel.getValueAt(i, n5), false, false, i, n5);
                int n8 = component2.getPreferredSize().width;
                if (n4 >= n8) continue;
                n4 = n8;
            }
            if (n4 > n2) {
                n4 = n2;
            }
            nArray[n5] = n4 + n;
            n7 += nArray[n5];
        }
        n5 = n3 - n7;
        if ((n5 -= n6) > 0) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n6) {
                n4 = n5 / n9;
                int n11 = n10++;
                nArray[n11] = nArray[n11] + n4;
                n5 -= n4;
                --n9;
            }
        }
        for (int i = 0; i < n6; ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(nArray[i]);
        }
    }

    public static void setBestColumnWidthsEx(JTable jTable, int n) {
        TableUtil.setBestColumnWidthsEx(jTable, n, Integer.MAX_VALUE);
    }

    public static void setBestColumnWidthsEx(JTable jTable, int n, int n2) {
        TableModel tableModel = jTable.getModel();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        TableCellRenderer tableCellRenderer = tableColumnModel.getColumn(0).getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        }
        if (tableCellRenderer == null) {
            return;
        }
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            TableCellRenderer tableCellRenderer2 = jTable.getDefaultRenderer(tableModel.getColumnClass(i));
            TableCellEditor tableCellEditor = jTable.getDefaultEditor(tableModel.getColumnClass(i));
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumnModel.getColumn(i).getHeaderValue(), false, false, 0, 0);
            int n3 = component.getPreferredSize().width;
            for (int j = 0; j < tableModel.getRowCount(); ++j) {
                int n4;
                Component component2;
                Component component3 = tableCellRenderer2.getTableCellRendererComponent(jTable, tableModel.getValueAt(j, i), false, false, j, i);
                int n5 = component3.getPreferredSize().width;
                if (n3 < n5) {
                    n3 = n5;
                }
                if (tableCellEditor == null || (component2 = tableCellEditor.getTableCellEditorComponent(jTable, tableModel.getValueAt(j, i), false, j, i)) == null || n3 >= (n4 = component2.getPreferredSize().width)) continue;
                n3 = n4;
            }
            if (n3 > n2) {
                n3 = n2;
            }
            tableColumnModel.getColumn(i).setPreferredWidth(n3 + n);
        }
    }
}

