/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.arch.IThrobber;
import com.elixirtech.arch.worker.AbortableSwingWorker;
import com.elixirtech.arch.worker.WorkerManager;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.ImageManager;
import com.elixirtech.ui.InfiniteThrobber;
import com.elixirtech.ui.SwingUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Throbber
extends JComponent
implements IThrobber {
    private static final String BASE = "com/elixirtech/icons/throbber/";
    private Image[] m_Images;
    private Dimension m_Size;
    private int m_Current;
    private Repaint m_Repaint = new Repaint();
    private InfiniteThrobber m_InfiniteThrobber;
    WorkerManager m_WorkerManager;
    long m_LastUpdate;

    public Throbber(WorkerManager workerManager) {
        this.m_WorkerManager = workerManager;
        this.enableEvents(16L);
        this.m_Images = new Image[8];
        this.m_Images[0] = ImageManager.getImageResource("com/elixirtech/icons/throbber/Throbber1.png");
        this.m_Images[1] = ImageManager.getImageResource("com/elixirtech/icons/throbber/Throbber2.png");
        this.m_Images[2] = ImageManager.getImageResource("com/elixirtech/icons/throbber/Throbber3.png");
        this.m_Images[3] = ImageManager.getImageResource("com/elixirtech/icons/throbber/Throbber4.png");
        this.m_Images[4] = ImageManager.getImageResource("com/elixirtech/icons/throbber/Throbber5.png");
        this.m_Images[5] = ImageManager.getImageResource("com/elixirtech/icons/throbber/Throbber6.png");
        this.m_Images[6] = ImageManager.getImageResource("com/elixirtech/icons/throbber/Throbber7.png");
        this.m_Images[7] = ImageManager.getImageResource("com/elixirtech/icons/throbber/Throbber8.png");
        this.m_Size = this.m_Images[0] != null ? new Dimension(this.m_Images[0].getWidth(null), this.m_Images[0].getHeight(null)) : new Dimension(0, 0);
        this.setToolTipText(Throbber.getString("Application.ProgressIndicator"));
    }

    @Override
    public void updateThrobber() {
        long l = System.currentTimeMillis();
        if (l < this.m_LastUpdate + 400L) {
            return;
        }
        ++this.m_Current;
        if (this.m_Current == this.m_Images.length) {
            this.m_Current = 0;
        }
        SwingUtil.invokeAndWait(this.m_Repaint);
    }

    @Override
    public void resetThrobber() {
        this.m_Current = this.m_Images.length - 1;
        this.updateThrobber();
    }

    @Override
    public void startInfiniteThrob() {
        if (this.m_InfiniteThrobber == null) {
            this.m_InfiniteThrobber = new InfiniteThrobber(this);
        }
        this.m_InfiniteThrobber.addThrob();
    }

    @Override
    public void stopInfiniteThrob() {
        assert (this.m_InfiniteThrobber != null);
        this.m_InfiniteThrobber.removeThrob();
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.m_Current % this.m_Images.length;
        if (this.m_Images[n] != null) {
            graphics.drawImage(this.m_Images[n], 0, 0, null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.m_Size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.m_Size;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.m_Size;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            List<AbortableSwingWorker> list = this.m_WorkerManager.getWorkers();
            if (list.size() == 0) {
                JMenuItem jMenuItem = new JMenuItem(Throbber.getString("Application.NoBackgroundTasks"));
                jMenuItem.setEnabled(false);
                jPopupMenu.add(jMenuItem);
            } else {
                for (AbortableSwingWorker abortableSwingWorker : list) {
                    jPopupMenu.add(new AbortAction(abortableSwingWorker));
                }
            }
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private static String getString(String string) {
        return Bundle.ARCH.getString(string);
    }

    private class Repaint
    implements Runnable {
        private Repaint() {
        }

        @Override
        public void run() {
            Graphics graphics = Throbber.this.getGraphics();
            Throbber.this.paint(graphics);
            graphics.dispose();
            Throbber.this.m_LastUpdate = System.currentTimeMillis();
        }
    }

    private class AbortAction
    extends AbstractAction {
        private AbortableSwingWorker m_Worker;

        public AbortAction(AbortableSwingWorker abortableSwingWorker) {
            super(MessageFormat.format(Throbber.getString("Application.Abort"), abortableSwingWorker.getName()));
            this.m_Worker = abortableSwingWorker;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.m_Worker.interrupt();
            Throbber.this.m_WorkerManager.unregister(this.m_Worker);
        }
    }
}

