/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.util.StrBuffer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class TimeFieldPane
extends JPanel
implements ItemListener {
    private static final String[] TYPES = new String[]{"seconds", "minutes", "hours", "days", "weeks", "No Expiry"};
    private static final String[] KEYS = new String[]{"TimeField.seconds", "TimeField.minutes", "TimeField.hours", "TimeField.days", "TimeField.weeks", "TimeField.NoExpiry"};
    private static final long[] DIVIDERS = new long[]{1L, 60L, 3600L, 86400L, 604800L, 0L};
    private JTextField m_TextField;
    private I18NComboBox m_ListTimeType = I18NComboBox.apply(I18NComboBox.buildNames(TYPES, Bundle.ARCH, KEYS));
    private long m_Duration;
    private boolean m_IsUpdating;

    public TimeFieldPane() {
        this(10);
    }

    public TimeFieldPane(int n) {
        this.m_ListTimeType.setSelectedIndex(0);
        this.buildUI(n);
        this.setDuration(0L);
    }

    private void buildUI(int n) {
        this.setLayout(new BorderLayout());
        this.m_TextField = new JTextField(n);
        this.add(this.m_TextField);
        this.m_TextField.setDocument(new NumberDoc());
        this.add((Component)this.m_ListTimeType, "East");
        this.m_ListTimeType.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.m_IsUpdating = true;
        this.m_TextField.setText(this.getConvertedDuration());
        this.m_IsUpdating = false;
    }

    public long getDuration() {
        int n = this.m_ListTimeType.getSelectedIndex();
        if (DIVIDERS[n] == 0L) {
            return 0L;
        }
        return this.m_Duration / DIVIDERS[n] * DIVIDERS[n];
    }

    public void setDuration(long l) {
        this.m_Duration = l;
        this.m_IsUpdating = true;
        if (this.m_Duration == 0L) {
            this.m_ListTimeType.setSelectedIndex(TYPES.length - 1);
        } else {
            this.m_ListTimeType.setSelectedIndex(0);
        }
        this.m_TextField.setText(this.getConvertedDuration());
        this.m_IsUpdating = false;
    }

    public Document getDocument() {
        return this.m_TextField.getDocument();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_TextField.setEnabled(bl);
        this.m_ListTimeType.setEnabled(bl);
    }

    private String getConvertedDuration() {
        int n = this.m_ListTimeType.getSelectedIndex();
        if (DIVIDERS[n] == 0L) {
            return "";
        }
        return String.valueOf(this.m_Duration / DIVIDERS[n]);
    }

    void updateConvertedDuration() {
        if (!this.m_IsUpdating) {
            long l;
            int n = this.m_ListTimeType.getSelectedIndex();
            String string = this.m_TextField.getText().trim();
            long l2 = l = string.length() > 0 ? Long.parseLong(string) : 0L;
            if (DIVIDERS[n] == 0L && l != 0L) {
                n = 0;
                this.m_Duration = l;
                this.m_ListTimeType.setSelectedIndex(0);
            } else {
                this.m_Duration = l * DIVIDERS[n];
            }
        }
    }

    final class NumberDoc
    extends PlainDocument {
        NumberDoc() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            StrBuffer strBuffer = new StrBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (!Character.isDigit(c)) continue;
                strBuffer.append(c);
            }
            super.insertString(n, strBuffer.toString(), attributeSet);
            TimeFieldPane.this.updateConvertedDuration();
        }
    }

    public static interface NumberRule {
        public void insertString(int var1, String var2, AttributeSet var3) throws BadLocationException;
    }
}

