/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.ui.FontMeasurer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;

public class TitledIcon
implements Icon {
    private Font m_Font;
    private Icon m_Icon;
    private String m_First;
    private String m_Second;
    private int m_FirstWidth;
    private int m_SecondWidth;
    private int m_Ascent;
    private int m_LineHeight;

    public TitledIcon(Icon icon, Font font, String string, String string2) {
        this.m_Icon = icon;
        this.m_Font = font;
        this.m_First = string;
        this.m_Second = string2;
        FontMeasurer fontMeasurer = FontMeasurer.get(false, false);
        Rectangle2D rectangle2D = fontMeasurer.getBounds(this.m_Font, this.m_First);
        this.m_FirstWidth = (int)rectangle2D.getWidth();
        this.m_LineHeight = (int)rectangle2D.getHeight();
        this.m_Ascent = (int)fontMeasurer.getAscent(this.m_Font);
        if (this.m_Second != null) {
            this.m_SecondWidth = (int)fontMeasurer.getWidth(this.m_Font, this.m_Second);
        }
    }

    @Override
    public int getIconWidth() {
        return Math.max(this.m_Icon.getIconWidth(), Math.max(this.m_FirstWidth, this.m_SecondWidth));
    }

    @Override
    public int getIconHeight() {
        if (this.m_Second == null) {
            return this.m_Icon.getIconHeight() + this.m_LineHeight;
        }
        return this.m_Icon.getIconHeight() + 2 * this.m_LineHeight;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3 = this.getIconWidth();
        int n4 = this.m_Icon.getIconWidth();
        int n5 = this.m_Icon.getIconHeight();
        this.m_Icon.paintIcon(component, graphics, n + (n3 - n4) / 2, n2);
        graphics.setFont(this.m_Font);
        graphics.setColor(Color.black);
        graphics.drawString(this.m_First, n + (n3 - this.m_FirstWidth) / 2, n2 + n5 + this.m_Ascent);
        if (this.m_Second != null) {
            graphics.drawString(this.m_Second, n + (n3 - this.m_SecondWidth) / 2, n2 + n5 + this.m_LineHeight + this.m_Ascent);
        }
    }
}

