/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.i18n.Bundle;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TransparencyPanel
extends AbstractColorChooserPanel
implements ChangeListener,
ActionListener {
    ColorSelectionModel m_Model;
    JSlider m_Scale;
    JTextField m_PercentField;
    boolean m_LocalChange;

    public TransparencyPanel(int n) {
        this.setLayout(new GridLayout(0, 1));
        this.m_Scale = new JSlider(0, 0, 255, n);
        this.m_Scale.addChangeListener(this);
        this.add(new JLabel(Bundle.ARCH.getString("TransparencyPanel.SELECT_AN_ALPHA_VALUE"), 0));
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(Bundle.ARCH.getString("TransparencyPanel.TRANSPARENT")));
        jPanel.add(this.m_Scale);
        jPanel.add(new JLabel(Bundle.ARCH.getString("TransparencyPanel.SOLID")));
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        this.m_PercentField = new JTextField(3);
        this.m_PercentField.setHorizontalAlignment(4);
        this.m_PercentField.addActionListener(this);
        jPanel2.add(this.m_PercentField);
        jPanel2.add(new JLabel(Bundle.ARCH.getString("TransparencyPanel.PERCENT")));
        this.m_PercentField.setText(String.valueOf(Math.round((double)n * 100.0 / 255.0)));
        this.add(jPanel2);
    }

    @Override
    protected void buildChooser() {
        this.m_Model = this.getColorSelectionModel();
        this.retainAlpha();
        this.m_Model.addChangeListener(new ColorChange());
    }

    @Override
    public void updateChooser() {
    }

    @Override
    public String getDisplayName() {
        return Bundle.ARCH.getString("TransparencyPanel.TRANSPARENCY");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Color color = this.m_Model.getSelectedColor();
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.m_Scale.getValue());
        this.m_LocalChange = true;
        this.m_Model.setSelectedColor(color2);
        this.m_LocalChange = false;
        this.m_PercentField.setText(String.valueOf(Math.round((double)this.m_Scale.getValue() * 100.0 / 255.0)));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        int n = 100;
        try {
            object = actionEvent.getActionCommand().trim();
            n = Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            this.m_PercentField.setText("100");
        }
        this.m_Scale.setValue(n * 255 / 100);
        object = this.m_Model.getSelectedColor();
        Color color = new Color(((Color)object).getRed(), ((Color)object).getGreen(), ((Color)object).getBlue(), this.m_Scale.getValue());
        this.m_LocalChange = true;
        this.m_Model.setSelectedColor(color);
        this.m_LocalChange = false;
    }

    protected void retainAlpha() {
        Color color = this.m_Model.getSelectedColor();
        if (color.getAlpha() != this.m_Scale.getValue()) {
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.m_Scale.getValue());
            this.m_Model.setSelectedColor(color2);
        }
    }

    private class ColorChange
    implements ChangeListener {
        private ColorChange() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (!TransparencyPanel.this.m_LocalChange) {
                if (TransparencyPanel.this.m_Scale.getValue() > 0) {
                    TransparencyPanel.this.retainAlpha();
                } else {
                    TransparencyPanel.this.m_Scale.setValue(255);
                }
            }
        }
    }
}

