/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.NumberDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class UnitField
extends JPanel
implements ItemListener,
DocumentListener {
    public static final UnitType[] MEASURES = new UnitType[]{new UnitType("pixels", 20.0, 2), new UnitType("twips", 1.0, 0), new UnitType("inches", 1440.0, 4), new UnitType("millimeters", 56.69291338582678, 4)};
    public static final UnitType[] PT_MEASURES = new UnitType[]{new UnitType("points", 20.0, 1), new UnitType("twips", 1.0, 0)};
    public static final int PIXELS = 0;
    public static final int POINTS = 0;
    public static final int TWIPS = 1;
    public static final int INCHES = 2;
    public static final int MILLIMETERS = 3;
    protected final UnitType[] m_Units;
    protected final JTextField m_Field;
    protected final JComboBox m_Combo;
    protected UnitType m_CurrentUnit;
    protected boolean m_Edited;
    protected Integer m_Value;
    private static int m_PreferredUnits;
    private static NumberFormat FORMATTER;

    public static UnitField newUnitField() {
        return new UnitField();
    }

    public static UnitField newUnitField(String string) {
        return new UnitField(string);
    }

    public static UnitField newUnitField(UnitType[] unitTypeArray, String string) {
        return new UnitField(unitTypeArray, string);
    }

    public static UnitField newPointUnitField() {
        UnitField unitField = new UnitField(PT_MEASURES, 0);
        return unitField;
    }

    public UnitField(String string) {
        this(MEASURES, UnitField.getPreferredUnits());
        this.setName(string);
    }

    public UnitField(UnitType[] unitTypeArray, String string) {
        this(unitTypeArray, UnitField.getPreferredUnits());
        this.setName(string);
    }

    public UnitField() {
        this(MEASURES, UnitField.getPreferredUnits());
    }

    public UnitField(UnitType[] unitTypeArray, int n) {
        this.m_Units = unitTypeArray;
        this.setLayout(new BorderLayout());
        this.m_Field = new JTextField(5);
        this.m_Field.setDocument(new NumberDocument());
        this.m_Field.setHorizontalAlignment(4);
        this.m_Combo = new JComboBox<UnitType>(this.m_Units);
        Dimension dimension = this.m_Combo.getPreferredSize();
        dimension.width += 10;
        this.m_Combo.setPreferredSize(dimension);
        this.m_CurrentUnit = this.m_Units[n];
        this.m_Combo.setSelectedItem(this.m_CurrentUnit);
        this.m_Combo.addItemListener(this);
        this.add((Component)this.m_Field, "Center");
        this.add((Component)this.m_Combo, "East");
        this.setIntValue(0);
        this.m_Field.getDocument().addDocumentListener(this);
    }

    public void setDocument(Document document) {
        this.m_Field.getDocument().removeDocumentListener(this);
        this.m_Field.setDocument(document);
        document.addDocumentListener(this);
    }

    public void setColumns(int n) {
        this.m_Field.setColumns(n);
    }

    public void setUnit(UnitType unitType) {
        this.m_Combo.setSelectedItem(unitType);
        Integer n = this.getValue();
        this.m_CurrentUnit = unitType;
        if (n != null) {
            this.setValue(n);
        }
    }

    public static UnitType getPreferredUnit() {
        return MEASURES[m_PreferredUnits];
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_Field.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.m_Field.removeActionListener(actionListener);
    }

    @Override
    public synchronized void addKeyListener(KeyListener keyListener) {
        this.m_Field.addKeyListener(keyListener);
    }

    @Override
    public synchronized void removeKeyListener(KeyListener keyListener) {
        this.m_Field.removeKeyListener(keyListener);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        this.m_Field.getDocument().addDocumentListener(documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        this.m_Field.getDocument().removeDocumentListener(documentListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_Field.setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return this.m_Field.isEnabled();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Integer n = this.getValue();
        this.m_CurrentUnit = (UnitType)this.m_Combo.getSelectedItem();
        if (n != null) {
            this.setValue(n);
        }
    }

    public int getIntValue() {
        Integer n = this.getValue();
        if (n == null) {
            return 0;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getValue() {
        if (!this.m_Edited) {
            return this.m_Value;
        }
        String string = this.m_Field.getText().trim();
        if (string.length() == 0) {
            this.m_Value = null;
            this.m_Edited = false;
            return null;
        }
        try {
            NumberFormat numberFormat = FORMATTER;
            synchronized (numberFormat) {
                FORMATTER.setMaximumFractionDigits(this.m_CurrentUnit.getMaximumFractionDigits());
                double d = FORMATTER.parse(string).doubleValue();
                this.m_Value = this.m_CurrentUnit.getBaseValue(d);
                this.m_Edited = false;
                return this.m_Value;
            }
        }
        catch (ParseException parseException) {
            this.m_Field.setText("0");
            Toolkit.getDefaultToolkit().beep();
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntValue(int n) {
        NumberFormat numberFormat = FORMATTER;
        synchronized (numberFormat) {
            FORMATTER.setMaximumFractionDigits(this.m_CurrentUnit.getMaximumFractionDigits());
            this.m_Field.setText(FORMATTER.format(this.m_CurrentUnit.getValue(n)));
        }
        this.m_Value = n;
        this.m_Edited = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Integer n) {
        if (n == null) {
            this.m_Field.setText("");
        } else {
            NumberFormat numberFormat = FORMATTER;
            synchronized (numberFormat) {
                FORMATTER.setMaximumFractionDigits(this.m_CurrentUnit.getMaximumFractionDigits());
                this.m_Field.setText(FORMATTER.format(this.m_CurrentUnit.getValue(n)));
            }
        }
        this.m_Value = n;
        this.m_Edited = false;
    }

    public static int getPreferredUnits() {
        return m_PreferredUnits;
    }

    public static void setPreferredUnits(int n) {
        m_PreferredUnits = n;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.m_Edited = true;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.m_Edited = true;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.m_Edited = true;
    }

    static {
        FORMATTER = NumberFormat.getNumberInstance();
    }

    public static class UnitType
    implements Serializable {
        private String m_Name;
        private String m_DisplayName;
        private double m_ToBase;
        private int m_MaximumFractionDigits;

        public UnitType(String string, double d, int n) {
            this.m_Name = string;
            try {
                this.m_DisplayName = Bundle.ARCH.getString("Unit." + this.m_Name);
            }
            catch (Throwable throwable) {
                this.m_DisplayName = this.m_Name;
                ElxLoggerJ.getLogger(UnitType.class).warn((Object)("Error reading resource: " + String.valueOf(throwable)), throwable);
            }
            this.m_ToBase = d;
            this.m_MaximumFractionDigits = n;
        }

        public String getName() {
            return this.m_Name;
        }

        public String toString() {
            return this.m_DisplayName;
        }

        public int getMaximumFractionDigits() {
            return this.m_MaximumFractionDigits;
        }

        public int getBaseValue(double d) {
            return (int)(d * this.m_ToBase);
        }

        public double getValue(int n) {
            return (double)n / this.m_ToBase;
        }
    }
}

