/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ZoomIcon
implements Icon {
    public static final int TYPE_CLIP = 1;
    public static final int TYPE_ZOOM = 2;
    public static final int TYPE_STRETCH = 3;
    private ImageIcon m_Image;
    private Dimension m_Dimension;
    private int m_Type;

    public ZoomIcon(ImageIcon imageIcon, Dimension dimension, int n) {
        this.m_Image = imageIcon;
        this.m_Dimension = dimension;
        this.m_Type = n;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.m_Type == 1) {
            Shape shape = graphics.getClip();
            graphics.clipRect(n, n2, this.m_Dimension.width, this.m_Dimension.height);
            graphics.drawImage(this.m_Image.getImage(), n, n2, null);
            graphics.setClip(shape);
        } else if (this.m_Type == 2) {
            float f = this.m_Image.getIconWidth();
            float f2 = this.m_Image.getIconHeight();
            float f3 = f / (float)this.m_Dimension.width;
            float f4 = f2 / (float)this.m_Dimension.height;
            float f5 = Math.max(f3, f4);
            int n3 = (int)(f / f5);
            int n4 = (int)(f2 / f5);
            int n5 = (this.m_Dimension.width - n3) / 2;
            int n6 = (this.m_Dimension.height - n4) / 2;
            Shape shape = graphics.getClip();
            graphics.clipRect(n, n2, this.m_Dimension.width, this.m_Dimension.height);
            graphics.drawImage(this.m_Image.getImage(), n + n5, n2 + n6, n + n5 + n3, n2 + n6 + n4, 0, 0, (int)f, (int)f2, null);
            graphics.setClip(shape);
        } else if (this.m_Type == 3) {
            int n7 = this.m_Image.getIconWidth();
            int n8 = this.m_Image.getIconHeight();
            Shape shape = graphics.getClip();
            graphics.clipRect(n, n2, this.m_Dimension.width, this.m_Dimension.height);
            graphics.drawImage(this.m_Image.getImage(), n, n2, this.m_Dimension.width, this.m_Dimension.height, 0, 0, n7, n8, null);
            graphics.setClip(shape);
        }
    }

    @Override
    public int getIconWidth() {
        return this.m_Dimension.width;
    }

    @Override
    public int getIconHeight() {
        return this.m_Dimension.height;
    }
}

