/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.print;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.i18n.I18NBypass;
import com.elixirtech.i18n.UIFactory;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.print.PrintDialog;
import com.elixirtech.util.CodeBlock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.util.ResourceBundle;
import javax.print.attribute.standard.PageRanges;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SwingPrintDialog
extends JDialog {
    private int m_Total;
    private JTextField m_PagesString;
    private JRadioButton m_All;
    private JRadioButton m_Pages;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SwingPrintDialog.class);
    private static ResourceBundle m_Bundle;

    SwingPrintDialog(Frame frame, int n) {
        super(frame, SwingPrintDialog.getString("Print-Dialog"), true);
        this.m_Total = n;
        this.buildView();
    }

    public void setPrintAll() {
        this.m_All.setSelected(true);
    }

    private void buildView() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(2, 2));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), SwingPrintDialog.getString("Page-Range")));
        this.m_All = new JRadioButton(SwingPrintDialog.getString("All"));
        jPanel.add(this.m_All);
        jPanel.add(I18NBypass.newLabel(this.m_Total + " " + SwingPrintDialog.getString("Pages")));
        this.m_Pages = new JRadioButton(SwingPrintDialog.getString("Pages123"));
        jPanel.add(this.m_Pages);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_All);
        buttonGroup.add(this.m_Pages);
        this.m_All.setSelected(true);
        this.m_PagesString = new JTextField(15);
        jPanel.add(this.m_PagesString);
        JPanel jPanel2 = new JPanel();
        JButton jButton = SwingFactory.newOkButton(new CodeBlock((Object)this, "setOK"));
        jPanel2.add(jButton);
        JButton jButton2 = SwingFactory.newCancelButton(new CodeBlock((Object)this, "setCancel"));
        jPanel2.add(jButton2);
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        this.pack();
    }

    public void setOK() {
        if (this.storePages()) {
            PrintDialog.ok = true;
            this.dispose();
        }
    }

    public void setCancel() {
        this.clearPages();
        PrintDialog.ok = false;
        this.dispose();
    }

    public void clearPages() {
        PrintDialog.pages = null;
    }

    public boolean storePages() {
        if (this.m_Pages.isSelected()) {
            try {
                PrintDialog.pages = new PageRanges(this.m_PagesString.getText());
            }
            catch (Exception exception) {
                this.promptError();
                return false;
            }
        } else {
            PrintDialog.pages = new PageRanges(1, this.m_Total);
        }
        return true;
    }

    private void promptError() {
        JOptionPane.showMessageDialog(this, SwingPrintDialog.getString("InvalidPageRange"), SwingPrintDialog.getString("Page-Range"), 0);
    }

    private static String getString(String string) {
        try {
            return m_Bundle.getString(string);
        }
        catch (Exception exception) {
            m_Log.warn((Object)("resource string " + string + " not found"));
            return string;
        }
    }

    static {
        try {
            m_Bundle = UIFactory.getBundle("i18n/base");
        }
        catch (Exception exception) {
            System.err.println("Can't load printdialog properties");
        }
    }
}

