/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.property;

import com.elixirtech.property.PropertyNode;
import com.elixirtech.property.PropertyType;
import com.elixirtech.ui.property.IPropertyRenderer;
import com.elixirtech.ui.property.PropertyTableEditor;
import com.elixirtech.ui.property.PropertyTableRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class BooleanRenderer
extends JCheckBox
implements IPropertyRenderer,
ItemListener {
    private PropertyTableEditor m_Editor;
    private PropertyNode m_Node;

    @Override
    public void init(PropertyTableEditor propertyTableEditor, PropertyNode propertyNode) {
        this.m_Editor = propertyTableEditor;
        this.m_Node = propertyNode;
        this.setOpaque(true);
        if (this.m_Node.getType() != PropertyType.BOOLEAN) {
            throw new IllegalArgumentException("Expected a Boolean property");
        }
        this.addItemListener(this);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n2 == 0) {
            TableCellRenderer tableCellRenderer = PropertyTableRenderer.getNodeRenderer();
            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        Boolean bl3 = (Boolean)this.m_Node.getValue();
        this.setSelected(Boolean.TRUE.equals(bl3));
        Color color = jTable.getBackground();
        if (n % 2 == 0) {
            color = UIManager.getColor("Table.alternateRowColor");
        }
        if (color != null) {
            this.setBackground(new Color(color.getRed(), color.getGreen(), color.getBlue()));
        }
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Boolean bl2 = (Boolean)this.m_Node.getValue();
        this.setSelected(Boolean.TRUE.equals(bl2));
        Color color = jTable.getBackground();
        if (n % 2 == 0) {
            color = UIManager.getColor("Table.alternateRowColor");
        }
        if (color != null) {
            this.setBackground(new Color(color.getRed(), color.getGreen(), color.getBlue()));
        }
        return this;
    }

    @Override
    public Object getCellValue() {
        return this.isSelected() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.m_Editor.fireEditingStopped();
    }
}

