/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.property;

import com.elixirtech.property.ChoicePropertyType;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.property.PropertyNode;
import com.elixirtech.ui.ComboUtil;
import com.elixirtech.ui.property.IPropertyRenderer;
import com.elixirtech.ui.property.PropertyTableEditor;
import com.elixirtech.ui.property.PropertyTableRenderer;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class ChoiceRenderer
extends JComboBox<Object>
implements IPropertyRenderer,
ItemListener {
    private PropertyTableEditor m_Editor;
    private PropertyNode m_Node;
    private boolean m_InternalChange;

    @Override
    public void init(PropertyTableEditor propertyTableEditor, PropertyNode propertyNode) {
        this.m_Editor = propertyTableEditor;
        this.m_Node = propertyNode;
        if (this.m_Node.getType().getTypeId() != 100) {
            throw new IllegalArgumentException("Expected a Choice property");
        }
        ComboUtil.stripComboBorder(this);
        this.setBackground(UIManager.getColor("TextField.background"));
        this.setFont(UIManager.getFont("TextField.font"));
        this.addItemListener(this);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n2 == 0) {
            TableCellRenderer tableCellRenderer = PropertyTableRenderer.getNodeRenderer();
            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        List<? extends PropertyHolder> list = this.m_Editor.getPropertyHolders();
        ChoicePropertyType choicePropertyType = (ChoicePropertyType)this.m_Node.getType();
        this.setModel(new DefaultComboBoxModel<Object>(choicePropertyType.getChoices(list)));
        Object object2 = this.m_Node.getValue();
        this.m_InternalChange = true;
        this.setSelectedItem(object2);
        this.m_InternalChange = false;
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        ChoicePropertyType choicePropertyType = (ChoicePropertyType)this.m_Node.getType();
        List<? extends PropertyHolder> list = this.m_Editor.getPropertyHolders();
        Object[] objectArray = choicePropertyType.getChoices(list);
        this.setModel(new DefaultComboBoxModel<Object>(objectArray));
        Object object2 = this.m_Node.getValue();
        this.m_InternalChange = true;
        this.setSelectedItem(object2);
        this.m_InternalChange = false;
        return this;
    }

    @Override
    public Object getCellValue() {
        return this.getSelectedItem();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.m_InternalChange && itemEvent.getStateChange() == 1) {
            this.m_Editor.fireEditingStopped();
        }
    }
}

