/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.property;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.PropertyNode;
import com.elixirtech.property.PropertyType;
import com.elixirtech.ui.ComboUtil;
import com.elixirtech.ui.Icons;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.property.IPropertyRenderer;
import com.elixirtech.ui.property.PropertyTableEditor;
import com.elixirtech.ui.property.PropertyTableRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class ColourRenderer
extends JComboBox<Object>
implements IPropertyRenderer,
ItemListener {
    static final Name CUSTOM_COLOR = new Name("<Custom>");
    public static final Object[] colors = new Object[]{new Name("Red"), new Name("Blue"), new Name("Black"), new Name("White"), new Name("Yellow"), new Name("Green"), CUSTOM_COLOR};
    private PropertyTableEditor m_Editor;
    private PropertyNode m_Node;
    static Color m_SelectedBackground = UIManager.getColor("ComboBox.selectionBackground");
    static Color m_Background = UIManager.getColor("TextField.background");
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ColourRenderer.class);

    @Override
    public void init(PropertyTableEditor propertyTableEditor, PropertyNode propertyNode) {
        this.m_Editor = propertyTableEditor;
        this.m_Node = propertyNode;
        if (this.m_Node.getType() != PropertyType.COLOUR) {
            throw new IllegalArgumentException("Expected a Colour property");
        }
        ComboUtil.stripComboBorder(this);
        this.setBackground(UIManager.getColor("TextField.background"));
        this.setFont(UIManager.getFont("TextField.font"));
        this.setRenderer(new ColourComboRenderer());
        this.addItemListener(this);
        this.setModel(new DefaultComboBoxModel<Object>(colors));
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n2 == 0) {
            TableCellRenderer tableCellRenderer = PropertyTableRenderer.getNodeRenderer();
            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        Object object2 = this.m_Node.getValue();
        for (int i = 0; i < colors.length - 1; ++i) {
            if (!((Name)colors[i]).getName().equals(object2)) continue;
            this.setSelectedItem(colors[i]);
            return this;
        }
        Color color = StandardColor.lookup((String)object2);
        System.out.println("Color " + String.valueOf(color) + " selected");
        this.setSelectedItem(color);
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Object object2 = this.m_Node.getValue();
        this.setSelectedItem(object2);
        return this;
    }

    @Override
    public Object getCellValue() {
        Object object = this.getSelectedItem();
        if (object instanceof Color) {
            return Integer.toString(((Color)object).getRGB());
        }
        if (object instanceof Name) {
            return ((Name)object).getName();
        }
        return null;
    }

    public String getColourName(Color color) {
        String string = StandardColor.getColorName(color);
        if (string == null) {
            string = "Custom";
        }
        return string;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.removeItemListener(this);
        Object object = this.getSelectedItem();
        m_Log.debug((Object)("itemStateChanged got value: " + String.valueOf(object)));
        if (object == CUSTOM_COLOR) {
            Color color = StandardColor.lookup((String)this.m_Node.getValue());
            Color color2 = JColorChooser.showDialog(this, Bundle.ARCH.getString("ChooseColour"), color);
            if (color2 != null) {
                String string = StandardColor.getColorName(color2);
                m_Log.debug((Object)("setting color name to " + string));
                this.m_Node.setValue((Object)string);
            } else {
                this.setSelectedItem(this.m_Node.getValue());
            }
        }
        this.m_Editor.fireEditingStopped();
        this.addItemListener(this);
    }

    private static class ColourComboRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        public ColourComboRenderer() {
            this.setOpaque(true);
            this.setFont(UIManager.getFont("TextField.font"));
        }

        @Override
        public void setBorder(Border border) {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (CUSTOM_COLOR == object) {
                this.setIcon(null);
                this.setText(CUSTOM_COLOR.getLabel());
            } else if (object instanceof Name) {
                Name name = (Name)object;
                Color color = StandardColor.lookup(name.getName());
                this.setIcon(color != null ? Icons.getColourIcon(color) : null);
                this.setText(name.getLabel());
            } else {
                m_Log.debug((Object)("Got a " + String.valueOf(object) + "(" + String.valueOf(object.getClass()) + ")"));
                this.setIcon(null);
                this.setText(">" + String.valueOf(object));
            }
            this.setBackground(bl ? m_SelectedBackground : m_Background);
            return this;
        }
    }
}

