/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.property;

import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.I18NName;
import com.elixirtech.i18n.I18NResources;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.property.PropertyNode;
import com.elixirtech.ui.ComboUtil;
import com.elixirtech.ui.property.I18NChoicePropertyType;
import com.elixirtech.ui.property.IPropertyRenderer;
import com.elixirtech.ui.property.PropertyTableEditor;
import com.elixirtech.ui.property.PropertyTableRenderer;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;

public class I18NChoiceRenderer
extends I18NComboBox
implements IPropertyRenderer,
ItemListener {
    public static ResourceBundle AllResourcesBundle = new I18NResources.AllResourcesBundle();
    private PropertyTableEditor m_Editor;
    private PropertyNode m_Node;
    private boolean m_InternalChange;

    @Override
    public void init(PropertyTableEditor propertyTableEditor, PropertyNode propertyNode) {
        this.m_Editor = propertyTableEditor;
        this.m_Node = propertyNode;
        if (this.m_Node.getType().getTypeId() != 100) {
            throw new IllegalArgumentException("Expected a Choice property");
        }
        ComboUtil.stripComboBorder(this);
        this.setBackground(UIManager.getColor("TextField.background"));
        this.setFont(UIManager.getFont("TextField.font"));
        this.addItemListener(this);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n2 == 0) {
            TableCellRenderer tableCellRenderer = PropertyTableRenderer.getNodeRenderer();
            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        List<? extends PropertyHolder> list = this.m_Editor.getPropertyHolders();
        I18NChoicePropertyType i18NChoicePropertyType = (I18NChoicePropertyType)this.m_Node.getType();
        Name[] nameArray = this.fixChoices(i18NChoicePropertyType.getChoices(list));
        this.setModel(new DefaultComboBoxModel<Name>(nameArray));
        Object object2 = this.m_Node.getValue();
        this.m_InternalChange = true;
        this.setSelectedId((String)object2);
        this.m_InternalChange = false;
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        I18NChoicePropertyType i18NChoicePropertyType = (I18NChoicePropertyType)this.m_Node.getType();
        List<? extends PropertyHolder> list = this.m_Editor.getPropertyHolders();
        Name[] nameArray = this.fixChoices(i18NChoicePropertyType.getChoices(list));
        this.setModel(new DefaultComboBoxModel<Name>(nameArray));
        Object object2 = this.m_Node.getValue();
        this.m_InternalChange = true;
        this.setSelectedId((String)object2);
        this.m_InternalChange = false;
        return this;
    }

    public Name[] fixChoices(Object[] objectArray) {
        Name[] nameArray = new Name[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Name) {
                nameArray[i] = (Name)objectArray[i];
                continue;
            }
            String string = String.valueOf(objectArray[i]);
            int n = string.indexOf(46);
            String string2 = string.substring(n + 1);
            nameArray[i] = I18NName.apply((String)string2, (ResourceBundle)AllResourcesBundle, (String)string);
        }
        return nameArray;
    }

    @Override
    public Object getCellValue() {
        return this.getSelectedId();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.m_InternalChange && itemEvent.getStateChange() == 1) {
            this.m_Editor.fireEditingStopped();
        }
    }
}

