/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.property;

import com.elixirtech.property.PropertyNode;
import com.elixirtech.property.PropertyType;
import com.elixirtech.ui.property.IPropertyRenderer;
import com.elixirtech.ui.property.PropertyTableEditor;
import com.elixirtech.ui.property.PropertyTableRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

public class IntegerRenderer
extends JTextField
implements IPropertyRenderer,
ActionListener {
    private PropertyTableEditor m_Editor;
    private PropertyNode m_Node;

    @Override
    public void init(PropertyTableEditor propertyTableEditor, PropertyNode propertyNode) {
        this.m_Editor = propertyTableEditor;
        this.m_Node = propertyNode;
        if (this.m_Node.getType() != PropertyType.INTEGER) {
            throw new IllegalArgumentException("Expected an Integer property");
        }
        this.setBorder(null);
        this.addActionListener(this);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n2 == 0) {
            TableCellRenderer tableCellRenderer = PropertyTableRenderer.getNodeRenderer();
            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        Integer n3 = (Integer)this.m_Node.getValue();
        if (n3 == null) {
            this.setText("");
        } else {
            this.setText(n3.toString());
        }
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        Integer n3 = (Integer)this.m_Node.getValue();
        if (n3 == null) {
            this.setText("");
        } else {
            this.setText(n3.toString());
        }
        return this;
    }

    @Override
    public Object getCellValue() {
        try {
            return Integer.valueOf(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return this.m_Node.getValue();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.m_Editor.fireEditingStopped();
    }
}

