/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.property;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyComposite;
import com.elixirtech.ui.Icons;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class NodeRenderer
extends DefaultTableCellRenderer {
    private static Font m_PlainFont;
    private static Font m_BoldFont;
    private static Icon m_NullIcon;
    private static Icon m_IndentIcon;
    private static ElxLoggerJ m_Log;

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (object instanceof Property) {
            Property property = (Property)object;
            if (property.getLabel().indexOf(".") >= 0) {
                jLabel.setIcon(m_IndentIcon);
            } else {
                jLabel.setIcon(m_NullIcon);
            }
            if (property.isLocalPropertyValue()) {
                jLabel.setFont(m_BoldFont);
            } else {
                jLabel.setFont(m_PlainFont);
            }
            jLabel.setText(property.getShortLabel());
        } else if (object instanceof PropertyComposite) {
            PropertyComposite propertyComposite = (PropertyComposite)object;
            if (propertyComposite.getLabel().indexOf(".") >= 0) {
                jLabel.setIcon(m_IndentIcon);
            } else {
                jLabel.setIcon(m_NullIcon);
            }
            jLabel.setFont(m_PlainFont);
            jLabel.setText(propertyComposite.getShortLabel());
        } else {
            m_Log.error((Object)("Expected a Property, got a " + object.getClass().getName()));
        }
        return this;
    }

    static {
        m_Log = ElxLoggerJ.getLogger(NodeRenderer.class);
        m_PlainFont = UIManager.getFont("Table.font");
        m_PlainFont = m_PlainFont.deriveFont(0);
        m_BoldFont = m_PlainFont.deriveFont(1);
        int n = Icons.getTreeExpandedIcon().getIconWidth();
        m_NullIcon = Icons.getIndentIcon(n);
        m_IndentIcon = Icons.getIndentIcon(n + 6);
    }
}

