/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.property;

import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.EscapableDialog;
import com.elixirtech.ui.ITabComponent;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.property.IApplyRepainter;
import com.elixirtech.util.CodeBlock;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeListener;

public class PropertyDialog
extends EscapableDialog {
    private final boolean m_ReadOnly;
    protected JTabbedPane m_Tabs = new JTabbedPane();
    private boolean m_IsFinished;
    private IApplyRepainter m_Apply;

    public PropertyDialog(JFrame jFrame, boolean bl, String string, IApplyRepainter iApplyRepainter) {
        super((Frame)jFrame, true);
        this.m_ReadOnly = bl;
        StringBuilder stringBuilder = new StringBuilder(string);
        if (this.m_ReadOnly) {
            stringBuilder.append(" (");
            stringBuilder.append(Bundle.ARCH.getString("Wizard.READ_ONLY"));
            stringBuilder.append(")");
        }
        this.setTitle(stringBuilder.toString());
        this.m_Apply = iApplyRepainter;
        this.setDefaultCloseOperation(2);
        this.initDialog();
    }

    public void addTab(ITabComponent iTabComponent) {
        JComponent jComponent = iTabComponent.getComponent();
        if (this.m_ReadOnly) {
            jComponent.setEnabled(false);
        }
        this.m_Tabs.addTab(iTabComponent.getName(), jComponent);
        if (iTabComponent instanceof ChangeListener) {
            this.m_Tabs.addChangeListener((ChangeListener)((Object)iTabComponent));
        }
    }

    public void selectProperty(String string) {
        Component[] componentArray = this.m_Tabs.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ITabComponent iTabComponent = (ITabComponent)((Object)componentArray[i]);
            if (!iTabComponent.containsProperty(string)) continue;
            this.m_Tabs.setSelectedComponent(iTabComponent.getComponent());
            break;
        }
    }

    public void performApply() {
        Component[] componentArray = this.m_Tabs.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ((ITabComponent)((Object)componentArray[i])).performFinish();
        }
        this.m_Apply.applyRepaint();
        this.m_IsFinished = true;
    }

    public void performFinish() {
        Component[] componentArray = this.m_Tabs.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ((ITabComponent)((Object)componentArray[i])).performFinish();
        }
        this.m_IsFinished = true;
        this.dispose();
    }

    public void performCancel() {
        this.dispose();
    }

    public boolean isFinished() {
        return this.m_IsFinished;
    }

    private void initDialog() {
        JButton jButton;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add(this.m_Tabs);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        if (this.m_Apply != null) {
            jButton = SwingFactory.newApplyButton(new CodeBlock((Object)this, "performApply"));
            if (this.m_ReadOnly) {
                jButton.setEnabled(false);
            }
            jPanel.add(jButton);
        }
        jButton = SwingFactory.newOkButton(new CodeBlock((Object)this, "performFinish"));
        if (this.m_ReadOnly) {
            jButton.setEnabled(false);
        }
        jPanel.add(jButton);
        jPanel.add(SwingFactory.newCancelButton(new CodeBlock((Object)this, "performCancel")));
        Bundle.ARCH_MAP.injectComponents("PropertyDialog.", jPanel);
        container.add((Component)jPanel, "South");
    }
}

