/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.property;

import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyComposite;
import com.elixirtech.property.PropertyGroup;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.property.PropertyNode;
import com.elixirtech.property.PropertyType;
import com.elixirtech.ui.property.PropertyTable;
import com.elixirtech.ui.property.PropertyTableEditor;
import com.elixirtech.ui.property.PropertyTableRenderer;
import com.elixirtech.ui.table.ElxTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class PropertyModel
extends ElxTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMNS = new String[]{"TableModel.Name", "TableModel.Property"};
    private final PropertyTable m_Table;
    private List<? extends PropertyHolder> m_PropertyHolders;
    private final List<PropertyNode> m_Properties = new ArrayList<PropertyNode>();
    private final List<PropertyNode> m_Rows = new ArrayList<PropertyNode>();
    private final List<Object> m_Renderers = new ArrayList<Object>();
    private final Set<Name> m_HiddenKeys = new HashSet<Name>();
    private boolean m_ReadOnly;

    public PropertyModel(PropertyTable propertyTable) {
        super(Bundle.ARCH, COLUMNS);
        this.m_Table = propertyTable;
        this.m_PropertyHolders = Collections.emptyList();
        this.buildProperties();
        this.updateRows();
    }

    public void addHiddenKey(Name name) {
        this.m_HiddenKeys.add(name);
    }

    public PropertyType getRowValueType(int n) {
        PropertyNode propertyNode = this.m_Rows.get(n);
        return propertyNode.getType();
    }

    public void setPropertyHolders(List<? extends PropertyHolder> list) {
        this.m_PropertyHolders = list;
        this.buildProperties();
        this.updateRows();
    }

    public List<? extends PropertyHolder> getPropertyHolders() {
        return this.m_PropertyHolders;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        return (TableCellRenderer)this.m_Renderers.get(n);
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        return (TableCellEditor)this.m_Renderers.get(n);
    }

    public PropertyNode getValueAt(int n, int n2) {
        return this.m_Rows.get(n);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return PropertyNode.class;
    }

    @Override
    public int getRowCount() {
        return this.m_Rows.size();
    }

    public void setReadOnly(boolean bl) {
        this.m_ReadOnly = bl;
    }

    public boolean isReadOnly() {
        return this.m_ReadOnly;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.m_ReadOnly) {
            return false;
        }
        PropertyNode propertyNode = this.m_Rows.get(n);
        if (propertyNode instanceof Property || propertyNode instanceof PropertyComposite) {
            return n2 == 1;
        }
        return false;
    }

    protected void buildProperties() {
        Cloneable cloneable;
        this.m_Properties.clear();
        Object object = new HashSet();
        Object object2 = this.m_PropertyHolders.iterator();
        if (object2.hasNext()) {
            object2.next().getPropertyNames(object);
        }
        while (object2.hasNext()) {
            cloneable = new HashSet();
            object2.next().getPropertyNames(cloneable);
            object.retainAll((Collection<?>)((Object)cloneable));
        }
        object.removeAll(this.m_HiddenKeys);
        object2 = new TreeSet();
        object2.addAll(object);
        object = object2;
        cloneable = new HashMap();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Name name = (Name)iterator.next();
            String string = name.getLabel();
            int n = string.indexOf(".");
            if (n > 0) {
                String string2 = string.substring(0, n);
                PropertyGroup propertyGroup = (PropertyGroup)cloneable.get(string2);
                if (propertyGroup == null) {
                    propertyGroup = new PropertyGroup(new Name(string2));
                    cloneable.put(string2, propertyGroup);
                    this.m_Properties.add((PropertyNode)propertyGroup);
                }
                propertyGroup.addChild(this.getProperty(name));
                continue;
            }
            this.m_Properties.add(this.getProperty(name));
        }
    }

    private PropertyNode getProperty(Name name) {
        PropertyHolder propertyHolder = this.m_PropertyHolders.get(0);
        if (this.m_PropertyHolders.size() == 1) {
            return propertyHolder.getProperty(name);
        }
        return new PropertyComposite(propertyHolder.getProperty(name), this.m_PropertyHolders);
    }

    protected void updateRows() {
        this.m_Rows.clear();
        this.m_Renderers.clear();
        for (PropertyNode propertyNode : this.m_Properties) {
            int n = propertyNode.getChildCount();
            if (n == 0) {
                this.m_Rows.add(propertyNode);
                this.m_Renderers.add(this.getRenderer(propertyNode));
                continue;
            }
            if (propertyNode.isExpanded()) {
                this.m_Rows.add(propertyNode);
                this.m_Renderers.add(this.getRenderer(propertyNode));
                int n2 = propertyNode.getChildCount();
                for (int i = 0; i < n2; ++i) {
                    PropertyNode propertyNode2 = propertyNode.getChild(i);
                    this.m_Rows.add(propertyNode2);
                    this.m_Renderers.add(this.getRenderer(propertyNode2));
                }
                continue;
            }
            this.m_Rows.add(propertyNode);
            this.m_Renderers.add(this.getRenderer(propertyNode));
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        PropertyNode propertyNode = this.m_Rows.get(n);
        propertyNode.setValue(object);
        this.m_Table.notifyChange(propertyNode.getName());
        this.fireTableRowsUpdated(n, n);
    }

    public Object getExpansionMemento() {
        HashSet<Name> hashSet = new HashSet<Name>();
        for (PropertyNode propertyNode : this.m_Rows) {
            if (!propertyNode.isExpanded()) continue;
            hashSet.add(propertyNode.getName());
        }
        return hashSet;
    }

    public void setExpansionMemento(Object object) {
        Set set = (Set)object;
        for (PropertyNode propertyNode : this.m_Rows) {
            if (!(propertyNode instanceof PropertyGroup) || !set.contains(propertyNode.getName())) continue;
            ((PropertyGroup)propertyNode).setExpanded(true);
        }
        this.updateRows();
    }

    private Object getRenderer(PropertyNode propertyNode) {
        if (propertyNode instanceof PropertyGroup) {
            return PropertyTableRenderer.getGroupRenderer();
        }
        return new PropertyTableEditor(this.m_Table, propertyNode);
    }
}

