/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.property;

import com.elixirtech.i18n.Bundle;
import com.elixirtech.i18n.Name;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyGroup;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.property.PropertyNode;
import com.elixirtech.ui.property.PropertyModel;
import com.elixirtech.ui.property.PropertyTableEditor;
import com.elixirtech.ui.property.PropertyTableListener;
import com.elixirtech.ui.table.ElxTable;
import com.elixirtech.util.CodeBlock;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PropertyTable
extends JPanel {
    final JTableEx m_Table;
    PropertyModel m_Model;
    final List<PropertyTableListener> m_Listeners;

    public PropertyTable() {
        this.setLayout(new BorderLayout());
        this.m_Model = new PropertyModel(this);
        this.m_Table = new JTableEx(this.m_Model);
        this.m_Table.setRowHeight(18);
        this.m_Listeners = new ArrayList<PropertyTableListener>();
        this.m_Table.getTableHeader().setReorderingAllowed(false);
        this.m_Table.addMouseListener(new Expander());
        this.add(new JScrollPane(this.m_Table));
    }

    public void addHiddenKey(Name name) {
        this.m_Model.addHiddenKey(name);
    }

    public void addPropertyTableListener(PropertyTableListener propertyTableListener) {
        this.m_Listeners.add(propertyTableListener);
    }

    public void removePropertyTableListener(PropertyTableListener propertyTableListener) {
        this.m_Listeners.remove(propertyTableListener);
    }

    public void notifyChange(Name name) {
        for (PropertyTableListener propertyTableListener : this.m_Listeners) {
            propertyTableListener.propertyChanged(name, this.m_Model.getPropertyHolders());
        }
    }

    public List<Property> getSelectedProperties() {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        int[] nArray = this.m_Table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            PropertyNode propertyNode = this.m_Model.getValueAt(nArray[i], 0);
            if (!(propertyNode instanceof Property)) continue;
            arrayList.add((Property)propertyNode);
        }
        return arrayList;
    }

    public void setPropertyHolders(List<? extends PropertyHolder> list) {
        Object object;
        if (this.m_Table.isEditing()) {
            object = (PropertyTableEditor)this.m_Table.getCellEditor();
            ((PropertyTableEditor)object).stopCellEditing();
        }
        this.m_Table.removeEditor();
        object = this.m_Model.getExpansionMemento();
        this.m_Model.setPropertyHolders(list);
        this.m_Model.setExpansionMemento(object);
    }

    public List<? extends PropertyHolder> getPropertyHolders() {
        return this.m_Model.getPropertyHolders();
    }

    public void revert() {
        int[] nArray = this.m_Table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            Property property;
            PropertyNode propertyNode = this.m_Model.getValueAt(nArray[i], 0);
            if (!(propertyNode instanceof Property) || !(property = (Property)propertyNode).isLocalPropertyValue()) continue;
            property.setValue(null);
            this.notifyChange(property.getName());
        }
        this.m_Table.repaint();
    }

    public boolean canRevert() {
        if (this.m_Model.isReadOnly()) {
            return false;
        }
        int[] nArray = this.m_Table.getSelectedRows();
        for (int i = 0; i < nArray.length; ++i) {
            Property property;
            PropertyNode propertyNode = this.m_Model.getValueAt(nArray[i], 0);
            if (!(propertyNode instanceof Property) || !(property = (Property)propertyNode).isLocalPropertyValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isEditing() {
        return this.m_Table.getCellEditor() != null;
    }

    public void disposeEditor() {
        TableCellEditor tableCellEditor = this.m_Table.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
            this.m_Table.removeEditor();
        }
    }

    public void setReadOnly(boolean bl) {
        this.m_Model.setReadOnly(bl);
    }

    protected void doPopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(Bundle.ARCH.getString("PropertyTable.RevertToStyle"));
        jMenuItem.setEnabled(this.canRevert());
        jMenuItem.addActionListener(new CodeBlock((Object)this, "revert"));
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private class JTableEx
    extends ElxTable {
        public JTableEx(TableModel tableModel) {
            this.setModel(tableModel);
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            return PropertyTable.this.m_Model.getCellRenderer(n, n2);
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            return PropertyTable.this.m_Model.getCellEditor(n, n2);
        }
    }

    private class Expander
    extends MouseAdapter {
        private Expander() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            PropertyNode propertyNode;
            int n;
            int n2;
            int n3 = PropertyTable.this.m_Table.rowAtPoint(mouseEvent.getPoint());
            if (!this.rowIsSelected(n3)) {
                PropertyTable.this.m_Table.getSelectionModel().setSelectionInterval(n3, n3);
            }
            if (mouseEvent.isPopupTrigger()) {
                PropertyTable.this.doPopup(mouseEvent);
            } else if (mouseEvent.getClickCount() == 1 && (n2 = PropertyTable.this.m_Table.columnAtPoint(mouseEvent.getPoint())) == 0 && (n = PropertyTable.this.m_Table.rowAtPoint(mouseEvent.getPoint())) >= 0 && (propertyNode = PropertyTable.this.m_Model.getValueAt(n, n2)) instanceof PropertyGroup) {
                ((PropertyGroup)propertyNode).toggleExpand();
                PropertyTable.this.m_Model.updateRows();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                PropertyTable.this.doPopup(mouseEvent);
            }
        }

        private boolean rowIsSelected(int n) {
            int[] nArray = PropertyTable.this.m_Table.getSelectedRows();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                return true;
            }
            return false;
        }
    }
}

