/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.property;

import com.elixirtech.i18n.Name;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.property.PropertyNode;
import com.elixirtech.ui.property.IPropertyRenderer;
import com.elixirtech.ui.property.PropertyTable;
import com.elixirtech.ui.property.RendererFactory;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class PropertyTableEditor
implements TableCellEditor,
TableCellRenderer,
Serializable {
    private static final long serialVersionUID = 1L;
    private final PropertyTable m_Table;
    private final PropertyNode m_Node;
    private final IPropertyRenderer m_Renderer;
    private final List<CellEditorListener> m_Listeners = new ArrayList<CellEditorListener>();
    private final ChangeEvent m_ChangeEvent = new ChangeEvent(this);

    public PropertyTableEditor(PropertyTable propertyTable, PropertyNode propertyNode) {
        this.m_Table = propertyTable;
        this.m_Node = propertyNode;
        this.m_Renderer = RendererFactory.getRenderer(this, this.m_Node);
    }

    public void notifyChange(Name name) {
        if (this.m_Table != null) {
            this.m_Table.notifyChange(name);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        return this.m_Renderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        return this.m_Renderer.getTableCellEditorComponent(jTable, object, bl, n, n2);
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.m_Listeners.add(cellEditorListener);
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCancelled();
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_Renderer.getCellValue();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return eventObject instanceof MouseEvent;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.m_Listeners.remove(cellEditorListener);
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void fireEditingCancelled() {
        ArrayList<CellEditorListener> arrayList = new ArrayList<CellEditorListener>();
        arrayList.addAll(this.m_Listeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((CellEditorListener)iterator.next()).editingCanceled(this.m_ChangeEvent);
        }
    }

    public void fireEditingStopped() {
        if (this.m_Table.isEditing()) {
            ArrayList<CellEditorListener> arrayList = new ArrayList<CellEditorListener>();
            arrayList.addAll(this.m_Listeners);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((CellEditorListener)iterator.next()).editingStopped(this.m_ChangeEvent);
            }
            this.m_Table.disposeEditor();
        }
    }

    public List<? extends PropertyHolder> getPropertyHolders() {
        return this.m_Table.getPropertyHolders();
    }
}

