/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.property;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.property.ChoicePropertyType;
import com.elixirtech.property.PropertyNode;
import com.elixirtech.property.PropertyType;
import com.elixirtech.ui.property.BooleanRenderer;
import com.elixirtech.ui.property.ChoiceRenderer;
import com.elixirtech.ui.property.ColourRenderer2;
import com.elixirtech.ui.property.I18NChoiceRenderer;
import com.elixirtech.ui.property.IPropertyRenderer;
import com.elixirtech.ui.property.IntegerRenderer;
import com.elixirtech.ui.property.PointRenderer;
import com.elixirtech.ui.property.PropertyTableEditor;
import com.elixirtech.ui.property.StringRenderer;
import com.elixirtech.ui.property.TwipRenderer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;

public class RendererFactory {
    private static final Map<PropertyType, Class<? extends IPropertyRenderer>> m_Renderers = new HashMap<PropertyType, Class<? extends IPropertyRenderer>>();
    private static final ElxLoggerJ m_Log;

    public static IPropertyRenderer getRenderer(PropertyTableEditor propertyTableEditor, PropertyNode propertyNode) {
        PropertyType propertyType = propertyNode.getType();
        if (propertyType.getTypeId() == 100) {
            JComboBox jComboBox;
            ChoicePropertyType choicePropertyType = (ChoicePropertyType)propertyType;
            if (choicePropertyType.isI18N()) {
                I18NChoiceRenderer i18NChoiceRenderer = new I18NChoiceRenderer();
                if (choicePropertyType.isEditable()) {
                    i18NChoiceRenderer.setEditable(true);
                }
                jComboBox = i18NChoiceRenderer;
            } else {
                ChoiceRenderer choiceRenderer = new ChoiceRenderer();
                if (choicePropertyType.isEditable()) {
                    choiceRenderer.setEditable(true);
                }
                jComboBox = choiceRenderer;
            }
            jComboBox.init(propertyTableEditor, propertyNode);
            return jComboBox;
        }
        try {
            Class<? extends IPropertyRenderer> clazz = m_Renderers.get(propertyType);
            if (clazz != null) {
                IPropertyRenderer iPropertyRenderer = clazz.newInstance();
                iPropertyRenderer.init(propertyTableEditor, propertyNode);
                return iPropertyRenderer;
            }
            m_Log.error((Object)("No renderer defined for type: " + propertyType.getName()));
            return null;
        }
        catch (Throwable throwable) {
            m_Log.error((Object)("Can't create renderer for type: " + propertyType.getName() + " id=" + propertyType.getTypeId()), throwable);
            return null;
        }
    }

    public static void addRenderer(PropertyType propertyType, Class<? extends IPropertyRenderer> clazz) {
        m_Renderers.put(propertyType, clazz);
    }

    static {
        m_Renderers.put(PropertyType.STRING, StringRenderer.class);
        m_Renderers.put(PropertyType.INTEGER, IntegerRenderer.class);
        m_Renderers.put(PropertyType.TWIP, TwipRenderer.class);
        m_Renderers.put(PropertyType.POINT, PointRenderer.class);
        m_Renderers.put(PropertyType.BOOLEAN, BooleanRenderer.class);
        m_Renderers.put(PropertyType.COLOUR, ColourRenderer2.class);
        m_Log = ElxLoggerJ.getLogger(RendererFactory.class);
    }
}

