/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.property;

import com.elixirtech.property.PropertyNode;
import com.elixirtech.property.PropertyType;
import com.elixirtech.ui.property.IPropertyRenderer;
import com.elixirtech.ui.property.PropertyTableEditor;
import com.elixirtech.ui.property.PropertyTableRenderer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

public class StringRenderer
extends JTextField
implements IPropertyRenderer,
ActionListener {
    private PropertyTableEditor m_Editor;
    private PropertyNode m_Node;

    @Override
    public void init(PropertyTableEditor propertyTableEditor, PropertyNode propertyNode) {
        this.m_Editor = propertyTableEditor;
        this.m_Node = propertyNode;
        if (this.m_Node.getType() != PropertyType.STRING) {
            throw new IllegalArgumentException("Expected a String property");
        }
        this.setBorder(null);
        this.addActionListener(this);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n2 == 0) {
            TableCellRenderer tableCellRenderer = PropertyTableRenderer.getNodeRenderer();
            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
        String string = (String)this.m_Node.getValue();
        if (string == null) {
            string = "";
        }
        this.setText(string);
        return this;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        String string = (String)this.m_Node.getValue();
        if (string == null) {
            string = "";
        }
        this.setText(string);
        return this;
    }

    @Override
    public Object getCellValue() {
        return this.getText();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.m_Editor.fireEditingStopped();
    }
}

