/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.table;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class BasicTableEditor
implements TableCellEditor,
TableCellRenderer {
    private final List<CellEditorListener> m_Listeners = new ArrayList<CellEditorListener>();
    private final ChangeEvent m_ChangeEvent = new ChangeEvent(this);

    @Override
    public abstract Component getTableCellRendererComponent(JTable var1, Object var2, boolean var3, boolean var4, int var5, int var6);

    @Override
    public abstract Component getTableCellEditorComponent(JTable var1, Object var2, boolean var3, int var4, int var5);

    @Override
    public abstract Object getCellEditorValue();

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.m_Listeners.add(cellEditorListener);
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCancelled();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return eventObject instanceof MouseEvent;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.m_Listeners.remove(cellEditorListener);
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void fireEditingCancelled() {
        ArrayList<CellEditorListener> arrayList = new ArrayList<CellEditorListener>();
        arrayList.addAll(this.m_Listeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((CellEditorListener)iterator.next()).editingCanceled(this.m_ChangeEvent);
        }
    }

    public void fireEditingStopped() {
        ArrayList<CellEditorListener> arrayList = new ArrayList<CellEditorListener>();
        arrayList.addAll(this.m_Listeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((CellEditorListener)iterator.next()).editingStopped(this.m_ChangeEvent);
        }
    }
}

