/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;

public class BasicTreeCellEditor
extends JPanel
implements TreeCellEditor,
ActionListener {
    private final JLabel m_Label;
    private final JTextField m_Text;
    private final List<CellEditorListener> m_Listeners = new ArrayList<CellEditorListener>();
    private final ChangeEvent m_ChangeEvent = new ChangeEvent(this);

    public BasicTreeCellEditor() {
        this.setLayout(new BorderLayout());
        this.m_Label = new JLabel();
        this.m_Text = new JTextField();
        this.m_Text.setBorder(null);
        this.add((Component)this.m_Label, "West");
        this.add((Component)this.m_Text, "Center");
        this.m_Text.addActionListener(this);
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.m_Text.setText(this.getName(object));
        this.m_Label.setIcon(this.getIcon(object));
        return this;
    }

    protected String getName(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    protected Icon getIcon(Object object) {
        return null;
    }

    @Override
    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.m_Listeners.add(cellEditorListener);
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCancelled();
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_Text.getText();
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return eventObject == null;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.m_Listeners.remove(cellEditorListener);
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fireEditingStopped();
    }

    protected void fireEditingCancelled() {
        ArrayList<CellEditorListener> arrayList = new ArrayList<CellEditorListener>();
        arrayList.addAll(this.m_Listeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((CellEditorListener)iterator.next()).editingCanceled(this.m_ChangeEvent);
        }
    }

    protected void fireEditingStopped() {
        ArrayList<CellEditorListener> arrayList = new ArrayList<CellEditorListener>();
        arrayList.addAll(this.m_Listeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((CellEditorListener)iterator.next()).editingStopped(this.m_ChangeEvent);
        }
    }
}

