/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.ui.tree;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class BasicTreeListener
implements MouseListener {
    private final JTree m_Tree;

    public BasicTreeListener(JTree jTree) {
        this.m_Tree = jTree;
        this.m_Tree.addMouseListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        } else {
            this.doSelect(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        } else {
            int n = mouseEvent.getClickCount();
            if (n == 2) {
                this.doDoubleClick(mouseEvent);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void doPopup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu;
        Point point = mouseEvent.getPoint();
        int n = this.m_Tree.getRowForLocation(point.x, point.y);
        if (!this.m_Tree.isRowSelected(n)) {
            this.m_Tree.setSelectionRow(n);
        }
        TreePath treePath = this.m_Tree.getPathForLocation(point.x, point.y);
        Object object = null;
        if (n != -1) {
            object = treePath.getLastPathComponent();
        }
        if ((jPopupMenu = this.getPopupMenu(object)) != null) {
            jPopupMenu.show(this.m_Tree, point.x, point.y);
        }
        mouseEvent.consume();
    }

    protected void doSelect(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.m_Tree.getRowForLocation(point.x, point.y);
        TreePath treePath = this.m_Tree.getPathForLocation(point.x, point.y);
        if (n != -1) {
            Object object = treePath.getLastPathComponent();
            this.doSelect(object);
            mouseEvent.consume();
        }
    }

    protected void doDoubleClick(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.m_Tree.getRowForLocation(point.x, point.y);
        TreePath treePath = this.m_Tree.getPathForLocation(point.x, point.y);
        if (n != -1) {
            Object object = treePath.getLastPathComponent();
            this.doDoubleClick(object);
            mouseEvent.consume();
        }
    }

    protected JPopupMenu getPopupMenu(Object object) {
        return null;
    }

    protected void doSelect(Object object) {
    }

    protected void doDoubleClick(Object object) {
    }
}

